/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.DpHyp;
import org.apache.calcite.rel.rules.HyperGraph;
import org.apache.calcite.rel.rules.ImmutableDphypJoinReorderRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class DphypJoinReorderRule
extends RelRule<Config>
implements TransformationRule {
    protected DphypJoinReorderRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        HyperGraph hyperGraph = (HyperGraph)call.rel(0);
        RelBuilder relBuilder = call.builder();
        DpHyp dpHyp = new DpHyp(hyperGraph, relBuilder, call.getMetadataQuery());
        dpHyp.startEnumerateJoin();
        RelNode orderedJoin = dpHyp.getBestPlan();
        if (orderedJoin == null) {
            return;
        }
        List<String> oriNames = hyperGraph.getRowType().getFieldNames();
        List<String> newNames = orderedJoin.getRowType().getFieldNames();
        ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
        RexBuilder rexBuilder = hyperGraph.getCluster().getRexBuilder();
        for (String oriName : oriNames) {
            projects.add(rexBuilder.makeInputRef(orderedJoin, newNames.indexOf(oriName)));
        }
        RelNode result = call.builder().push(orderedJoin).project(projects).build();
        call.transformTo(result);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableDphypJoinReorderRule.Config.of().withOperandSupplier(b1 -> b1.operand(HyperGraph.class).anyInputs());

        @Override
        default public DphypJoinReorderRule toRule() {
            return new DphypJoinReorderRule(this);
        }
    }
}

