/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.HyperEdge;
import org.apache.calcite.rel.rules.LongBitmap;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVariable;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HyperGraph
extends AbstractRelNode {
    private final List<RelNode> inputs;
    private final RelDataType rowType;
    private final List<HyperEdge> edges;
    private final ImmutableBitSet complexEdgesBitmap;
    private final HashMap<Long, BitSet> ccpUsedEdgesMap;
    private final HashMap<Long, BitSet> simpleEdgesMap;
    private final HashMap<Long, BitSet> complexEdgesMap;
    private final HashMap<Long, BitSet> overlapEdgesMap;

    protected HyperGraph(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, List<HyperEdge> edges, RelDataType rowType) {
        super(cluster, traitSet);
        this.inputs = Lists.newArrayList(inputs);
        this.edges = Lists.newArrayList(edges);
        this.rowType = rowType;
        ImmutableBitSet.Builder bitSetBuilder = ImmutableBitSet.builder();
        for (int i = 0; i < edges.size(); ++i) {
            if (edges.get(i).isSimple()) continue;
            bitSetBuilder.set(i);
        }
        this.complexEdgesBitmap = bitSetBuilder.build();
        this.ccpUsedEdgesMap = new HashMap();
        this.simpleEdgesMap = new HashMap();
        this.complexEdgesMap = new HashMap();
        this.overlapEdgesMap = new HashMap();
    }

    protected HyperGraph(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, List<HyperEdge> edges, RelDataType rowType, ImmutableBitSet complexEdgesBitmap, HashMap<Long, BitSet> ccpUsedEdgesMap, HashMap<Long, BitSet> simpleEdgesMap, HashMap<Long, BitSet> complexEdgesMap, HashMap<Long, BitSet> overlapEdgesMap) {
        super(cluster, traitSet);
        this.inputs = Lists.newArrayList(inputs);
        this.edges = Lists.newArrayList(edges);
        this.rowType = rowType;
        this.complexEdgesBitmap = complexEdgesBitmap;
        this.ccpUsedEdgesMap = new HashMap<Long, BitSet>(ccpUsedEdgesMap);
        this.simpleEdgesMap = new HashMap<Long, BitSet>(simpleEdgesMap);
        this.complexEdgesMap = new HashMap<Long, BitSet>(complexEdgesMap);
        this.overlapEdgesMap = new HashMap<Long, BitSet>(overlapEdgesMap);
    }

    @Override
    public HyperGraph copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HyperGraph(this.getCluster(), traitSet, inputs, this.edges, this.rowType, this.complexEdgesBitmap, this.ccpUsedEdgesMap, this.simpleEdgesMap, this.complexEdgesMap, this.overlapEdgesMap);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (Ord ord : Ord.zip(this.inputs)) {
            pw.input("input#" + ord.i, (RelNode)ord.e);
        }
        List hyperEdges = this.edges.stream().map(hyperEdge -> hyperEdge.toString()).collect(Collectors.toList());
        pw.item("edges", String.join((CharSequence)",", hyperEdges));
        return pw;
    }

    @Override
    public List<RelNode> getInputs() {
        return this.inputs;
    }

    @Override
    public void replaceInput(int ordinalInParent, RelNode p) {
        this.inputs.set(ordinalInParent, p);
        this.recomputeDigest();
    }

    @Override
    public RelDataType deriveRowType() {
        return this.rowType;
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        ArrayList<HyperEdge> shuttleEdges = new ArrayList<HyperEdge>();
        for (HyperEdge edge : this.edges) {
            HyperEdge shuttleEdge = new HyperEdge(edge.getLeftNodeBitmap(), edge.getRightNodeBitmap(), edge.getJoinType(), shuttle.apply(edge.getCondition()));
            shuttleEdges.add(shuttleEdge);
        }
        return new HyperGraph(this.getCluster(), this.traitSet, this.inputs, shuttleEdges, this.rowType, this.complexEdgesBitmap, this.ccpUsedEdgesMap, this.simpleEdgesMap, this.complexEdgesMap, this.overlapEdgesMap);
    }

    public List<HyperEdge> getEdges() {
        return this.edges;
    }

    public long getNeighborBitmap(long csg, long forbidden) {
        long neighbors = 0L;
        List simpleEdges = this.simpleEdgesMap.getOrDefault(csg, new BitSet()).stream().mapToObj(this.edges::get).collect(Collectors.toList());
        for (HyperEdge edge : simpleEdges) {
            neighbors |= edge.getNodeBitmap();
        }
        neighbors &= (forbidden |= csg) ^ 0xFFFFFFFFFFFFFFFFL;
        forbidden |= neighbors;
        List complexEdges = this.complexEdgesMap.getOrDefault(csg, new BitSet()).stream().mapToObj(this.edges::get).collect(Collectors.toList());
        for (HyperEdge edge : complexEdges) {
            long leftBitmap = edge.getLeftNodeBitmap();
            long rightBitmap = edge.getRightNodeBitmap();
            if (LongBitmap.isSubSet(leftBitmap, csg) && !LongBitmap.isOverlap(rightBitmap, forbidden)) {
                neighbors |= Long.lowestOneBit(rightBitmap);
                continue;
            }
            if (!LongBitmap.isSubSet(rightBitmap, csg) || LongBitmap.isOverlap(leftBitmap, forbidden)) continue;
            neighbors |= Long.lowestOneBit(leftBitmap);
        }
        return neighbors;
    }

    public List<HyperEdge> connectCsgCmp(long csg, long cmp) {
        Preconditions.checkArgument((boolean)this.simpleEdgesMap.containsKey(csg));
        Preconditions.checkArgument((boolean)this.simpleEdgesMap.containsKey(cmp));
        ArrayList<HyperEdge> connectedEdges = new ArrayList<HyperEdge>();
        BitSet connectedEdgesBitmap = new BitSet();
        connectedEdgesBitmap.or(this.simpleEdgesMap.getOrDefault(csg, new BitSet()));
        connectedEdgesBitmap.or(this.complexEdgesMap.getOrDefault(csg, new BitSet()));
        BitSet cmpEdgesBitmap = new BitSet();
        cmpEdgesBitmap.or(this.simpleEdgesMap.getOrDefault(cmp, new BitSet()));
        cmpEdgesBitmap.or(this.complexEdgesMap.getOrDefault(cmp, new BitSet()));
        connectedEdgesBitmap.and(cmpEdgesBitmap);
        BitSet mayMissedEdges = new BitSet();
        mayMissedEdges.or(this.complexEdgesBitmap.toBitSet());
        mayMissedEdges.andNot(this.ccpUsedEdgesMap.getOrDefault(csg, new BitSet()));
        mayMissedEdges.andNot(this.ccpUsedEdgesMap.getOrDefault(cmp, new BitSet()));
        mayMissedEdges.andNot(connectedEdgesBitmap);
        mayMissedEdges.stream().forEach(index -> {
            HyperEdge edge = this.edges.get(index);
            if (LongBitmap.isSubSet(edge.getNodeBitmap(), csg | cmp)) {
                connectedEdgesBitmap.set(index);
            }
        });
        BitSet curUsedEdges = new BitSet();
        curUsedEdges.or(connectedEdgesBitmap);
        curUsedEdges.or(this.ccpUsedEdgesMap.getOrDefault(csg, new BitSet()));
        curUsedEdges.or(this.ccpUsedEdgesMap.getOrDefault(cmp, new BitSet()));
        if (this.ccpUsedEdgesMap.containsKey(csg | cmp)) {
            Preconditions.checkArgument((boolean)curUsedEdges.equals(this.ccpUsedEdgesMap.get(csg | cmp)));
        }
        this.ccpUsedEdgesMap.put(csg | cmp, curUsedEdges);
        connectedEdgesBitmap.stream().forEach(index -> connectedEdges.add(this.edges.get(index)));
        return connectedEdges;
    }

    public void initEdgeBitMap(long subset) {
        BitSet simpleBitSet = new BitSet();
        BitSet complexBitSet = new BitSet();
        BitSet overlapBitSet = new BitSet();
        for (int i = 0; i < this.edges.size(); ++i) {
            HyperEdge edge = this.edges.get(i);
            if (HyperGraph.isAccurateEdge(edge, subset)) {
                if (edge.isSimple()) {
                    simpleBitSet.set(i);
                    continue;
                }
                complexBitSet.set(i);
                continue;
            }
            if (!HyperGraph.isOverlapEdge(edge, subset)) continue;
            overlapBitSet.set(i);
        }
        this.simpleEdgesMap.put(subset, simpleBitSet);
        this.complexEdgesMap.put(subset, complexBitSet);
        this.overlapEdgesMap.put(subset, overlapBitSet);
    }

    public void updateEdgesForUnion(long subset1, long subset2) {
        HyperEdge edge;
        long unionSet;
        if (!this.simpleEdgesMap.containsKey(subset1)) {
            this.initEdgeBitMap(subset1);
        }
        if (!this.simpleEdgesMap.containsKey(subset2)) {
            this.initEdgeBitMap(subset2);
        }
        if (this.simpleEdgesMap.containsKey(unionSet = subset1 | subset2)) {
            return;
        }
        BitSet unionSimpleBitSet = new BitSet();
        unionSimpleBitSet.or(this.simpleEdgesMap.getOrDefault(subset1, new BitSet()));
        unionSimpleBitSet.or(this.simpleEdgesMap.getOrDefault(subset2, new BitSet()));
        BitSet unionComplexBitSet = new BitSet();
        unionComplexBitSet.or(this.complexEdgesMap.getOrDefault(subset1, new BitSet()));
        unionComplexBitSet.or(this.complexEdgesMap.getOrDefault(subset2, new BitSet()));
        BitSet unionOverlapBitSet = new BitSet();
        unionOverlapBitSet.or(this.overlapEdgesMap.getOrDefault(subset1, new BitSet()));
        unionOverlapBitSet.or(this.overlapEdgesMap.getOrDefault(subset2, new BitSet()));
        for (int index : unionOverlapBitSet.stream().toArray()) {
            edge = this.edges.get(index);
            if (!HyperGraph.isAccurateEdge(edge, unionSet)) continue;
            unionComplexBitSet.set(index);
            unionOverlapBitSet.set(index, false);
        }
        for (int index : unionSimpleBitSet.stream().toArray()) {
            edge = this.edges.get(index);
            if (HyperGraph.isAccurateEdge(edge, unionSet)) continue;
            unionSimpleBitSet.set(index, false);
        }
        for (int index : unionComplexBitSet.stream().toArray()) {
            edge = this.edges.get(index);
            if (HyperGraph.isAccurateEdge(edge, unionSet)) continue;
            unionComplexBitSet.set(index, false);
        }
        this.simpleEdgesMap.put(unionSet, unionSimpleBitSet);
        this.complexEdgesMap.put(unionSet, unionComplexBitSet);
        this.overlapEdgesMap.put(unionSet, unionOverlapBitSet);
    }

    private static boolean isAccurateEdge(HyperEdge edge, long subset) {
        boolean isLeftEnd = LongBitmap.isSubSet(edge.getLeftNodeBitmap(), subset) && !LongBitmap.isOverlap(edge.getRightNodeBitmap(), subset);
        boolean isRightEnd = LongBitmap.isSubSet(edge.getRightNodeBitmap(), subset) && !LongBitmap.isOverlap(edge.getLeftNodeBitmap(), subset);
        return isLeftEnd || isRightEnd;
    }

    private static boolean isOverlapEdge(HyperEdge edge, long subset) {
        boolean isLeftEnd = LongBitmap.isOverlap(edge.getLeftNodeBitmap(), subset) && !LongBitmap.isOverlap(edge.getRightNodeBitmap(), subset);
        boolean isRightEnd = LongBitmap.isOverlap(edge.getRightNodeBitmap(), subset) && !LongBitmap.isOverlap(edge.getLeftNodeBitmap(), subset);
        return isLeftEnd || isRightEnd;
    }

    public @Nullable JoinRelType extractJoinType(List<HyperEdge> edges) {
        JoinRelType joinType = edges.get(0).getJoinType();
        for (int i = 1; i < edges.size(); ++i) {
            if (edges.get(i).getJoinType() == joinType) continue;
            return null;
        }
        return joinType;
    }

    public RexNode extractJoinCond(RelNode left, RelNode right, List<HyperEdge> edges) {
        ArrayList<RexNode> joinConds = new ArrayList<RexNode>();
        final ArrayList<RelDataTypeField> fieldList = new ArrayList<RelDataTypeField>(left.getRowType().getFieldList());
        fieldList.addAll(right.getRowType().getFieldList());
        final ArrayList<String> names = new ArrayList<String>(left.getRowType().getFieldNames());
        names.addAll(right.getRowType().getFieldNames());
        RexShuttle inputName2InputRefShuttle = new RexShuttle(){

            @Override
            protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean @Nullable [] update) {
                ImmutableList.Builder clonedOperands = ImmutableList.builder();
                for (RexNode rexNode : exprs) {
                    RexNode clonedOperand;
                    if (rexNode instanceof RexInputFieldName) {
                        int index = names.indexOf(((RexInputFieldName)rexNode).getName());
                        clonedOperand = new RexInputRef(index, ((RelDataTypeField)fieldList.get(index)).getType());
                    } else {
                        clonedOperand = rexNode.accept(this);
                    }
                    if (clonedOperand != rexNode && update != null) {
                        update[0] = true;
                    }
                    clonedOperands.add((Object)clonedOperand);
                }
                return clonedOperands.build();
            }
        };
        for (HyperEdge edge : edges) {
            RexNode inputRefCond = edge.getCondition().accept(inputName2InputRefShuttle);
            joinConds.add(inputRefCond);
        }
        return RexUtil.composeConjunction(left.getCluster().getRexBuilder(), joinConds);
    }

    public void convertHyperEdgeCond(RelBuilder builder) {
        int fieldIndex = 0;
        final List<RelDataTypeField> fieldList = this.rowType.getFieldList();
        for (int nodeIndex = 0; nodeIndex < this.inputs.size(); ++nodeIndex) {
            RelNode input = this.inputs.get(nodeIndex);
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < input.getRowType().getFieldCount(); ++i) {
                projects.add(new RexInputRef(i, fieldList.get(fieldIndex).getType()));
                names.add(fieldList.get(fieldIndex).getName());
                ++fieldIndex;
            }
            builder.push(input).project(projects, names, true);
            this.replaceInput(nodeIndex, builder.build());
        }
        RexShuttle inputRef2inputNameShuttle = new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef inputRef) {
                int index = inputRef.getIndex();
                return new RexInputFieldName(((RelDataTypeField)fieldList.get(index)).getName(), ((RelDataTypeField)fieldList.get(index)).getType());
            }
        };
        for (int i = 0; i < this.edges.size(); ++i) {
            HyperEdge edge = this.edges.get(i);
            RexNode convertCond = edge.getCondition().accept(inputRef2inputNameShuttle);
            HyperEdge convertEdge = new HyperEdge(edge.getLeftNodeBitmap(), edge.getRightNodeBitmap(), edge.getJoinType(), convertCond);
            this.edges.set(i, convertEdge);
        }
    }

    private static class RexInputFieldName
    extends RexVariable {
        RexInputFieldName(String fieldName, RelDataType type) {
            super(fieldName, type);
        }

        @Override
        public <R> R accept(RexVisitor<R> visitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof RexInputFieldName && this.name == ((RexInputFieldName)obj).name && this.type.equals(((RexInputFieldName)obj).type);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

