/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlAlter;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.ImmutableNullableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlSetOption
extends SqlAlter {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SET_OPTION", SqlKind.SET_OPTION){

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            SqlNode scopeNode = operands[0];
            return new SqlSetOption(pos, scopeNode == null ? null : scopeNode.toString(), operands[1], operands[2]);
        }
    };
    @Deprecated
    SqlIdentifier name;
    SqlNode nameAsSqlNode;
    @Nullable SqlNode value;

    public SqlSetOption(SqlParserPos pos, @Nullable String scope, SqlNode name, @Nullable SqlNode value) {
        super(pos, scope);
        this.scope = scope;
        this.name = Objects.requireNonNull(name, "name") instanceof SqlIdentifier ? (SqlIdentifier)name : new SqlIdentifier(name.toString(), name.getParserPosition());
        this.nameAsSqlNode = name;
        this.value = value;
    }

    @Deprecated
    public SqlSetOption(SqlParserPos pos, @Nullable String scope, SqlIdentifier name, @Nullable SqlNode value) {
        this(pos, scope, (SqlNode)name, value);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.SET_OPTION;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<@Nullable SqlNode> operandList = new ArrayList<SqlNode>();
        if (this.scope == null) {
            operandList.add(null);
        } else {
            operandList.add(new SqlIdentifier(this.scope, SqlParserPos.ZERO));
        }
        operandList.add(this.name);
        operandList.add(this.value);
        return ImmutableNullableList.copyOf(operandList);
    }

    @Override
    public void setOperand(int i, @Nullable SqlNode operand) {
        switch (i) {
            case 0: {
                if (operand != null) {
                    this.scope = ((SqlIdentifier)operand).getSimple();
                    break;
                }
                this.scope = null;
                break;
            }
            case 1: {
                this.setName(Objects.requireNonNull(operand, "operand"));
                break;
            }
            case 2: {
                this.value = operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.getDialect().unparseSqlSetOption(writer, leftPrec, rightPrec, this);
    }

    @Override
    protected void unparseAlterOperation(SqlWriter writer, int leftPrec, int rightPrec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.value != null) {
            validator.validate(this.value);
        }
    }

    @Deprecated
    public SqlIdentifier getName() {
        return this.name;
    }

    public SqlNode name() {
        return this.nameAsSqlNode;
    }

    @Deprecated
    public void setName(SqlIdentifier name) {
        this.name = name;
    }

    public void setName(SqlNode name) {
        this.name = name instanceof SqlIdentifier ? (SqlIdentifier)name : new SqlIdentifier(name.toString(), name.getParserPosition());
        this.nameAsSqlNode = name;
    }

    public @Nullable SqlNode getValue() {
        return this.value;
    }

    public void setValue(SqlNode value) {
        this.value = value;
    }
}

