/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.ScanCloseReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ScanCloseReplicaRequestBuilder;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class ScanCloseReplicaRequestDeserializer
implements MessageDeserializer<ScanCloseReplicaRequest> {
    private final ScanCloseReplicaRequestBuilder msg;

    ScanCloseReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.scanCloseReplicaRequest();
    }

    public Class<ScanCloseReplicaRequest> klass() {
        return ScanCloseReplicaRequest.class;
    }

    public ScanCloseReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("scanId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.scanId(tmp);
                reader.incrementState();
            }
            case 2: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactionId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ScanCloseReplicaRequest.class);
    }
}

