/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessageGroup;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMetaRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataRequest;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotRequestMessage;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotTxDataRequest;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.OutgoingSnapshot;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.PartitionSnapshots;
import org.apache.ignite.internal.partition.replicator.raft.snapshot.outgoing.PartitionsSnapshots;
import org.apache.ignite.internal.storage.StorageClosedException;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class OutgoingSnapshotsManager
implements PartitionsSnapshots,
IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(OutgoingSnapshotsManager.class);
    private final String nodeName;
    private final MessagingService messagingService;
    private final FailureProcessor failureProcessor;
    private final Map<UUID, OutgoingSnapshot> snapshots = new ConcurrentHashMap<UUID, OutgoingSnapshot>();
    private final Map<PartitionKey, PartitionSnapshotsImpl> snapshotsByPartition = new ConcurrentHashMap<PartitionKey, PartitionSnapshotsImpl>();
    private volatile ExecutorService executor;

    public OutgoingSnapshotsManager(String nodeName, MessagingService messagingService, FailureProcessor failureProcessor) {
        this.nodeName = nodeName;
        this.messagingService = messagingService;
        this.failureProcessor = failureProcessor;
    }

    public MessagingService messagingService() {
        return this.messagingService;
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(4, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)IgniteThreadFactory.create((String)this.nodeName, (String)"outgoing-snapshots", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[]{ThreadOperation.STORAGE_READ}));
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        this.executor = threadPoolExecutor;
        this.messagingService.addMessageHandler(PartitionReplicationMessageGroup.class, this::handleMessage);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    void startOutgoingSnapshot(UUID snapshotId, OutgoingSnapshot outgoingSnapshot) {
        this.snapshots.put(snapshotId, outgoingSnapshot);
        PartitionSnapshotsImpl partitionSnapshots = this.getPartitionSnapshots(outgoingSnapshot.partitionKey());
        partitionSnapshots.freezeAndAddUnderLock(outgoingSnapshot);
    }

    private PartitionSnapshotsImpl getPartitionSnapshots(PartitionKey partitionKey) {
        return this.snapshotsByPartition.computeIfAbsent(partitionKey, key -> new PartitionSnapshotsImpl());
    }

    @Override
    public void finishOutgoingSnapshot(UUID snapshotId) {
        OutgoingSnapshot removedSnapshot = this.snapshots.remove(snapshotId);
        if (removedSnapshot != null) {
            PartitionSnapshotsImpl partitionSnapshots = this.getPartitionSnapshots(removedSnapshot.partitionKey());
            partitionSnapshots.removeUnderLock(removedSnapshot);
            removedSnapshot.close();
        }
    }

    private void handleMessage(NetworkMessage networkMessage, InternalClusterNode sender, @Nullable Long correlationId) {
        if (!(networkMessage instanceof SnapshotRequestMessage)) {
            return;
        }
        assert (correlationId != null);
        OutgoingSnapshot outgoingSnapshot = this.snapshots.get(((SnapshotRequestMessage)networkMessage).id());
        if (outgoingSnapshot == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Unexpected snapshot request message has been received [message={}]", new Object[]{networkMessage});
            }
            return;
        }
        CompletableFuture.supplyAsync(() -> OutgoingSnapshotsManager.handleSnapshotRequestMessage(networkMessage, outgoingSnapshot), this.executor).whenCompleteAsync((response, throwable) -> this.respond((NetworkMessage)response, (Throwable)throwable, sender, correlationId), (Executor)this.executor);
    }

    @Nullable
    private static NetworkMessage handleSnapshotRequestMessage(NetworkMessage networkMessage, OutgoingSnapshot outgoingSnapshot) {
        switch (networkMessage.messageType()) {
            case 10: {
                return outgoingSnapshot.handleSnapshotMetaRequest((SnapshotMetaRequest)networkMessage);
            }
            case 12: {
                return outgoingSnapshot.handleSnapshotMvDataRequest((SnapshotMvDataRequest)networkMessage);
            }
            case 15: {
                return outgoingSnapshot.handleSnapshotTxDataRequest((SnapshotTxDataRequest)networkMessage);
            }
        }
        return null;
    }

    private void respond(@Nullable NetworkMessage response, @Nullable Throwable throwable, InternalClusterNode sender, long correlationId) {
        if (throwable != null) {
            if (!ExceptionUtils.hasCause((Throwable)throwable, (Class[])new Class[]{NodeStoppingException.class, StorageClosedException.class})) {
                this.failureProcessor.process(new FailureContext(throwable, "Something went wrong while handling a request"));
            }
            return;
        }
        if (response == null) {
            return;
        }
        this.messagingService.respond(sender, response, correlationId).whenComplete((v, e) -> {
            if (e != null) {
                LOG.error("Could not send a response with correlationId={}", e, new Object[]{correlationId});
            }
        });
    }

    @Override
    public PartitionSnapshots partitionSnapshots(PartitionKey partitionKey) {
        return this.getPartitionSnapshots(partitionKey);
    }

    @Override
    public void cleanupOutgoingSnapshots(PartitionKey partitionKey) {
        PartitionSnapshots partitionSnapshots = this.snapshotsByPartition.remove(partitionKey);
        if (partitionSnapshots == null) {
            return;
        }
        partitionSnapshots.acquireReadLock();
        try {
            partitionSnapshots.ongoingSnapshots().forEach(snapshot -> this.finishOutgoingSnapshot(snapshot.id()));
        }
        finally {
            partitionSnapshots.releaseReadLock();
        }
    }

    private static class PartitionSnapshotsImpl
    implements PartitionSnapshots {
        private final List<OutgoingSnapshot> snapshots = new ArrayList<OutgoingSnapshot>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        private PartitionSnapshotsImpl() {
        }

        private void freezeAndAddUnderLock(OutgoingSnapshot snapshot) {
            this.lock.writeLock().lock();
            try {
                snapshot.freezeScopeUnderMvLock();
                this.snapshots.add(snapshot);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private void removeUnderLock(OutgoingSnapshot snapshot) {
            this.lock.writeLock().lock();
            try {
                this.snapshots.remove(snapshot);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public void acquireReadLock() {
            this.lock.readLock().lock();
        }

        @Override
        public void releaseReadLock() {
            this.lock.readLock().unlock();
        }

        @Override
        public List<OutgoingSnapshot> ongoingSnapshots() {
            return Collections.unmodifiableList(this.snapshots);
        }
    }
}

