/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.proto;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.QualifiedNameHelper;
import org.jetbrains.annotations.Nullable;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageFormatException;
import org.msgpack.core.MessageNeverUsedFormatException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessageSizeException;
import org.msgpack.core.MessageTypeException;

public class ClientMessageUnpacker
implements AutoCloseable {
    private final ByteBuf buf;
    private int refCnt = 1;

    public ClientMessageUnpacker(ByteBuf buf) {
        assert (buf != null);
        this.buf = buf;
    }

    private static MessageSizeException overflowU32Size(int u32) {
        long lv = (long)(u32 & Integer.MAX_VALUE) + 0x80000000L;
        return new MessageSizeException(lv);
    }

    private static MessagePackException unexpected(String expected, byte b) {
        MessageFormat format = MessageFormat.valueOf((byte)b);
        if (format == MessageFormat.NEVER_USED) {
            return new MessageNeverUsedFormatException(String.format("Expected %s, but encountered 0xC1 \"NEVER_USED\" byte", expected));
        }
        String name = format.getValueType().name();
        String typeName = name.charAt(0) + name.substring(1).toLowerCase();
        return new MessageTypeException(String.format("Expected %s, but got %s (%02x)", expected, typeName, b));
    }

    public int unpackInt() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: {
                return this.buf.readUnsignedByte();
            }
            case -48: {
                return this.buf.readByte();
            }
            case -51: {
                return this.buf.readUnsignedShort();
            }
            case -47: {
                return this.buf.readShort();
            }
            case -50: 
            case -46: {
                return this.buf.readInt();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public int tryUnpackInt(int defaultValue) {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: {
                return this.buf.readUnsignedByte();
            }
            case -48: {
                return this.buf.readByte();
            }
            case -51: {
                return this.buf.readUnsignedShort();
            }
            case -47: {
                return this.buf.readShort();
            }
            case -50: 
            case -46: {
                return this.buf.readInt();
            }
        }
        this.buf.readerIndex(this.buf.readerIndex() - 1);
        return defaultValue;
    }

    public String unpackString() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int len = this.unpackRawStringHeader();
        int pos = this.buf.readerIndex();
        String res = this.buf.toString(pos, len, StandardCharsets.UTF_8);
        this.buf.readerIndex(pos + len);
        return res;
    }

    public void unpackNil() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (code == -64) {
            return;
        }
        throw ClientMessageUnpacker.unexpected("Nil", code);
    }

    public boolean unpackBoolean() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -62: {
                return false;
            }
            case -61: {
                return true;
            }
        }
        throw ClientMessageUnpacker.unexpected("boolean", code);
    }

    public byte unpackByte() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: 
            case -48: {
                return this.buf.readByte();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public short unpackShort() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: {
                return this.buf.readUnsignedByte();
            }
            case -48: {
                return this.buf.readByte();
            }
            case -51: 
            case -47: {
                return this.buf.readShort();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public long unpackLong() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixInt((byte)code)) {
            return code;
        }
        switch (code) {
            case -52: {
                return this.buf.readUnsignedByte();
            }
            case -48: {
                return this.buf.readByte();
            }
            case -51: {
                return this.buf.readUnsignedShort();
            }
            case -47: {
                return this.buf.readShort();
            }
            case -50: {
                return this.buf.readUnsignedInt();
            }
            case -46: {
                return this.buf.readInt();
            }
            case -49: 
            case -45: {
                return this.buf.readLong();
            }
        }
        throw ClientMessageUnpacker.unexpected("Integer", code);
    }

    public float unpackFloat() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -54: {
                return this.buf.readFloat();
            }
            case -53: {
                return (float)this.buf.readDouble();
            }
        }
        throw ClientMessageUnpacker.unexpected("Float", code);
    }

    public double unpackDouble() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -54: {
                return this.buf.readFloat();
            }
            case -53: {
                return this.buf.readDouble();
            }
        }
        throw ClientMessageUnpacker.unexpected("Float", code);
    }

    public ExtensionTypeHeader unpackExtensionTypeHeader() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        switch (code) {
            case -44: {
                return new ExtensionTypeHeader(this.buf.readByte(), 1);
            }
            case -43: {
                return new ExtensionTypeHeader(this.buf.readByte(), 2);
            }
            case -42: {
                return new ExtensionTypeHeader(this.buf.readByte(), 4);
            }
            case -41: {
                return new ExtensionTypeHeader(this.buf.readByte(), 8);
            }
            case -40: {
                return new ExtensionTypeHeader(this.buf.readByte(), 16);
            }
            case -57: {
                int length = this.readLength8();
                byte type = this.buf.readByte();
                return new ExtensionTypeHeader(type, length);
            }
            case -56: {
                int length = this.readLength16();
                byte type = this.buf.readByte();
                return new ExtensionTypeHeader(type, length);
            }
            case -55: {
                int length = this.readLength32();
                byte type = this.buf.readByte();
                return new ExtensionTypeHeader(type, length);
            }
        }
        throw ClientMessageUnpacker.unexpected("Ext", code);
    }

    public int unpackBinaryHeader() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixedRaw((byte)code)) {
            return code & 0x1F;
        }
        switch (code) {
            case -60: {
                return this.readLength8();
            }
            case -59: {
                return this.readLength16();
            }
            case -58: {
                return this.readLength32();
            }
        }
        throw ClientMessageUnpacker.unexpected("Binary", code);
    }

    public boolean tryUnpackNil() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int idx = this.buf.readerIndex();
        byte code = this.buf.getByte(idx);
        if (code == -64) {
            this.buf.readerIndex(idx + 1);
            return true;
        }
        return false;
    }

    public byte[] readPayload(int length) {
        assert (this.refCnt > 0) : "Unpacker is closed";
        byte[] res = new byte[length];
        this.buf.readBytes(res);
        return res;
    }

    public void readPayload(ByteBuffer target) {
        assert (this.refCnt > 0) : "Unpacker is closed";
        this.buf.readBytes(target);
    }

    public byte[] readBinary() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int length = this.unpackBinaryHeader();
        return this.readPayload(length);
    }

    public ByteBuffer readBinaryUnsafe() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int length = this.unpackBinaryHeader();
        int idx = this.buf.readerIndex();
        ByteBuffer byteBuffer = this.buf.internalNioBuffer(idx, length).slice();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buf.readerIndex(idx + length);
        return byteBuffer;
    }

    public void skipValues(int count) {
        assert (this.refCnt > 0) : "Unpacker is closed";
        while (count > 0) {
            byte code = this.buf.readByte();
            MessageFormat f = MessageFormat.valueOf((byte)code);
            switch (f) {
                case POSFIXINT: 
                case NEGFIXINT: 
                case BOOLEAN: 
                case NIL: {
                    break;
                }
                case FIXMAP: {
                    int mapLen = code & 0xF;
                    count += mapLen * 2;
                    break;
                }
                case FIXARRAY: {
                    int arrayLen = code & 0xF;
                    count += arrayLen;
                    break;
                }
                case FIXSTR: {
                    int strLen = code & 0x1F;
                    this.skipBytes(strLen);
                    break;
                }
                case INT8: 
                case UINT8: {
                    this.skipBytes(1);
                    break;
                }
                case INT16: 
                case UINT16: {
                    this.skipBytes(2);
                    break;
                }
                case INT32: 
                case UINT32: 
                case FLOAT32: {
                    this.skipBytes(4);
                    break;
                }
                case INT64: 
                case UINT64: 
                case FLOAT64: {
                    this.skipBytes(8);
                    break;
                }
                case BIN8: 
                case STR8: {
                    this.skipBytes(this.readLength8());
                    break;
                }
                case BIN16: 
                case STR16: {
                    this.skipBytes(this.readLength16());
                    break;
                }
                case BIN32: 
                case STR32: {
                    this.skipBytes(this.readLength32());
                    break;
                }
                case FIXEXT1: {
                    this.skipBytes(2);
                    break;
                }
                case FIXEXT2: {
                    this.skipBytes(3);
                    break;
                }
                case FIXEXT4: {
                    this.skipBytes(5);
                    break;
                }
                case FIXEXT8: {
                    this.skipBytes(9);
                    break;
                }
                case FIXEXT16: {
                    this.skipBytes(17);
                    break;
                }
                case EXT8: {
                    this.skipBytes(this.readLength8() + 1);
                    break;
                }
                case EXT16: {
                    this.skipBytes(this.readLength16() + 1);
                    break;
                }
                case EXT32: {
                    this.skipBytes(this.readLength32() + 1);
                    break;
                }
                case ARRAY16: {
                    count += this.readLength16();
                    break;
                }
                case ARRAY32: {
                    count += this.readLength32();
                    break;
                }
                case MAP16: {
                    count += this.readLength16() * 2;
                    break;
                }
                case MAP32: {
                    count += this.readLength32() * 2;
                    break;
                }
                default: {
                    throw new MessageFormatException("Unexpected format code: " + code);
                }
            }
            --count;
        }
    }

    public UUID unpackUuid() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 3) {
            throw new MessageTypeException("Expected UUID extension (3), but got " + type);
        }
        if (len != 16) {
            throw new MessageSizeException("Expected 16 bytes for UUID extension, but got " + len, (long)len);
        }
        return new UUID(this.buf.readLongLE(), this.buf.readLongLE());
    }

    @Nullable
    public UUID unpackUuidNullable() {
        return this.tryUnpackNil() ? null : this.unpackUuid();
    }

    public BitSet unpackBitSet() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        ExtensionTypeHeader hdr = this.unpackExtensionTypeHeader();
        byte type = hdr.getType();
        int len = hdr.getLength();
        if (type != 8) {
            throw new MessageTypeException("Expected BITSET extension (7), but got " + type);
        }
        byte[] bytes = this.readPayload(len);
        return BitSet.valueOf(bytes);
    }

    @Nullable
    public BitSet unpackBitSetNullable() {
        return this.tryUnpackNil() ? null : this.unpackBitSet();
    }

    public int[] unpackIntArray() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int size = this.unpackInt();
        if (size == 0) {
            return ArrayUtils.INT_EMPTY_ARRAY;
        }
        int[] res = new int[size];
        for (int i = 0; i < size; ++i) {
            res[i] = this.unpackInt();
        }
        return res;
    }

    public long[] unpackLongArray() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        int size = this.unpackInt();
        if (size == 0) {
            return ArrayUtils.LONG_EMPTY_ARRAY;
        }
        long[] res = new long[size];
        for (int i = 0; i < size; ++i) {
            res[i] = this.unpackInt();
        }
        return res;
    }

    public BatchedArguments unpackBatchedArgumentsFromBinaryTupleArray() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        if (this.tryUnpackNil()) {
            return null;
        }
        int rowLen = this.unpackInt();
        int rows = this.unpackInt();
        this.unpackBoolean();
        BatchedArguments args = BatchedArguments.create();
        for (int i = 0; i < rows; ++i) {
            args.add(this.unpackObjectArrayFromBinaryTuple(rowLen));
        }
        return args;
    }

    public Object[] unpackObjectArrayFromBinaryTuple(int size) {
        assert (this.refCnt > 0) : "Unpacker is closed";
        if (this.tryUnpackNil()) {
            return null;
        }
        Object[] args = new Object[size];
        BinaryTupleReader reader = new BinaryTupleReader(size * 3, this.readBinaryUnsafe());
        for (int i = 0; i < size; ++i) {
            args[i] = ClientBinaryTupleUtils.readObject(reader, i * 3);
        }
        return args;
    }

    public Object[] unpackObjectArrayFromBinaryTuple() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        if (this.tryUnpackNil()) {
            return null;
        }
        int size = this.unpackInt();
        if (size == 0) {
            return ArrayUtils.OBJECT_EMPTY_ARRAY;
        }
        Object[] args = new Object[size];
        BinaryTupleReader reader = new BinaryTupleReader(size * 3, this.readBinaryUnsafe());
        for (int i = 0; i < size; ++i) {
            args[i] = ClientBinaryTupleUtils.readObject(reader, i * 3);
        }
        return args;
    }

    public Object unpackObjectFromBinaryTuple() {
        assert (this.refCnt > 0) : "Unpacker is closed";
        if (this.tryUnpackNil()) {
            return null;
        }
        BinaryTupleReader reader = new BinaryTupleReader(3, this.readBinaryUnsafe());
        return ClientBinaryTupleUtils.readObject(reader, 0);
    }

    public ClientMessageUnpacker retain() {
        ++this.refCnt;
        this.buf.retain();
        return this;
    }

    @Override
    public void close() {
        if (this.refCnt == 0) {
            return;
        }
        --this.refCnt;
        if (this.buf.refCnt() > 0) {
            this.buf.release();
        }
    }

    public int unpackRawStringHeader() {
        byte code = this.buf.readByte();
        if (MessagePack.Code.isFixedRaw((byte)code)) {
            return code & 0x1F;
        }
        switch (code) {
            case -39: {
                return this.readLength8();
            }
            case -38: {
                return this.readLength16();
            }
            case -37: {
                return this.readLength32();
            }
        }
        throw ClientMessageUnpacker.unexpected("String", code);
    }

    @Nullable
    public Instant unpackInstantNullable() {
        if (this.tryUnpackNil()) {
            return null;
        }
        return this.unpackInstant();
    }

    @Nullable
    public Byte unpackByteNullable() {
        if (this.tryUnpackNil()) {
            return null;
        }
        return this.unpackByte();
    }

    @Nullable
    public String unpackStringNullable() {
        if (this.tryUnpackNil()) {
            return null;
        }
        return this.unpackString();
    }

    public Instant unpackInstant() {
        long seconds = this.unpackLong();
        int nanos = this.unpackInt();
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public List<DeploymentUnit> unpackDeploymentUnits() {
        int size = this.tryUnpackNil() ? 0 : this.unpackInt();
        ArrayList<DeploymentUnit> res = new ArrayList<DeploymentUnit>(size);
        for (int i = 0; i < size; ++i) {
            res.add(new DeploymentUnit(this.unpackString(), this.unpackString()));
        }
        return res;
    }

    public QualifiedName unpackQualifiedName() {
        String schemaName = this.unpackString();
        String objectName = this.unpackString();
        return QualifiedNameHelper.fromNormalized((String)schemaName, (String)objectName);
    }

    private int readLength8() {
        return this.buf.readUnsignedByte();
    }

    private int readLength16() {
        return this.buf.readUnsignedShort();
    }

    private int readLength32() {
        int u32 = this.buf.readInt();
        if (u32 < 0) {
            throw ClientMessageUnpacker.overflowU32Size(u32);
        }
        return u32;
    }

    private void skipBytes(int bytes) {
        this.buf.readerIndex(this.buf.readerIndex() + bytes);
    }
}

