/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.handshake;

import io.netty.channel.Channel;
import io.netty.channel.ChannelId;
import io.netty.channel.EventLoop;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.netty.ChannelKey;
import org.apache.ignite.internal.util.CompletableFutures;
import reactor.util.annotation.Nullable;

public class HandshakeEventLoopSwitcher {
    private static final IgniteLogger LOG = Loggers.forClass(HandshakeEventLoopSwitcher.class);
    private final List<EventLoop> executors;
    private final Map<Integer, Set<ChannelId>> activeChannelMap;
    private final Map<ChannelKey, Integer> channelReservationMap = new HashMap<ChannelKey, Integer>();

    public HandshakeEventLoopSwitcher(List<EventLoop> eventLoops) {
        this.executors = eventLoops;
        this.activeChannelMap = new HashMap<Integer, Set<ChannelId>>(eventLoops.size());
    }

    public CompletableFuture<Void> switchEventLoopIfNeeded(Channel channel) {
        return this.switchEventLoopIfNeeded(channel, null);
    }

    public CompletableFuture<Void> switchEventLoopIfNeeded(Channel channel, @Nullable ChannelKey channelKey) {
        ChannelId channelId = channel.id();
        EventLoop targetEventLoop = this.eventLoopForKey(channelId, channelKey);
        if (targetEventLoop != channel.eventLoop()) {
            CompletableFuture<Void> fut = new CompletableFuture<Void>();
            channel.deregister().addListener(deregistrationFuture -> {
                if (!deregistrationFuture.isSuccess()) {
                    LOG.error("Cannot deregister a channel from an event loop", deregistrationFuture.cause());
                    fut.completeExceptionally(deregistrationFuture.cause());
                    channel.close();
                    return;
                }
                targetEventLoop.register(channel).addListener(registrationFuture -> {
                    if (!registrationFuture.isSuccess()) {
                        LOG.error("Cannot register a channel with an event loop", registrationFuture.cause());
                        fut.completeExceptionally(registrationFuture.cause());
                        channel.close();
                        return;
                    }
                    channel.closeFuture().addListener(future -> this.channelUnregistered(channelId));
                    fut.complete(null);
                });
            });
            return fut;
        }
        return CompletableFutures.nullCompletedFuture();
    }

    private synchronized EventLoop eventLoopForKey(ChannelId channelId, @Nullable ChannelKey channelKey) {
        Integer idx;
        if (channelKey != null && (idx = this.channelReservationMap.get(channelKey)) != null) {
            return this.executors.get(idx);
        }
        int minCnt = Integer.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < this.executors.size(); ++i) {
            Set channelIds = this.activeChannelMap.getOrDefault(i, Set.of());
            if (channelIds.contains(channelId)) {
                assert (channelKey == null) : "Channel key should be null if the channel is already registered in the event loop";
                return this.executors.get(index);
            }
            int cnt = channelIds.size();
            if (cnt >= minCnt) continue;
            minCnt = cnt;
            index = i;
            if (cnt == 0) break;
        }
        this.activeChannelMap.computeIfAbsent(index, key -> new HashSet()).add(channelId);
        if (channelKey != null) {
            this.channelReservationMap.put(channelKey, index);
        }
        EventLoop eventLoop = this.executors.get(index);
        LOG.debug("Channel mapped to the loop [channelId={}, channelKey={}, eventLoopIndex={}]", new Object[]{channelId, channelKey, index});
        return eventLoop;
    }

    private synchronized void channelUnregistered(ChannelId channelId) {
        for (Set<ChannelId> channelKeys : this.activeChannelMap.values()) {
            if (channelKeys.remove(channelId)) break;
        }
    }

    public synchronized void nodeLeftTopology(InternalClusterNode node) {
        this.channelReservationMap.entrySet().removeIf(entry -> ((ChannelKey)entry.getKey()).launchId().equals(node.id()));
    }
}

