/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class AcknowledgementMessageDeserializer
implements MessageDeserializer<AcknowledgementMessage> {
    private final AcknowledgementMessageBuilder msg;

    AcknowledgementMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.acknowledgementMessage();
    }

    public Class<AcknowledgementMessage> klass() {
        return AcknowledgementMessage.class;
    }

    public AcknowledgementMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("receivedMessages");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.receivedMessages(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(AcknowledgementMessage.class);
    }
}

