/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite.internal.tx.message.TxCleanupMessage;
import org.apache.ignite.internal.tx.message.TxCleanupMessageBuilder;
import org.apache.ignite.internal.tx.message.TxCleanupMessageSerializer;

public class TxCleanupMessageImpl
implements TxCleanupMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final List<EnlistedPartitionGroupMessage> groups;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID txId;

    private TxCleanupMessageImpl(boolean commit, HybridTimestamp commitTimestamp, List<EnlistedPartitionGroupMessage> groups, HybridTimestamp timestamp, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.groups = groups;
        this.timestamp = timestamp;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public List<EnlistedPartitionGroupMessage> groups() {
        return this.groups;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return TxCleanupMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxCleanupMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxCleanupMessageImpl otherMessage = (TxCleanupMessageImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.groups, otherMessage.groups) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.commitTimestamp, this.groups, this.timestamp, this.txId);
        return result;
    }

    public TxCleanupMessageImpl clone() {
        try {
            return (TxCleanupMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxCleanupMessageBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groups != null) {
            for (EnlistedPartitionGroupMessage obj : this.groups) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groups != null) {
            for (EnlistedPartitionGroupMessage obj : this.groups) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements TxCleanupMessageBuilder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private List<EnlistedPartitionGroupMessage> groups;
        private HybridTimestamp timestamp;
        private UUID txId;

        private Builder() {
        }

        @Override
        public TxCleanupMessageBuilder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public TxCleanupMessageBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public TxCleanupMessageBuilder groups(List<EnlistedPartitionGroupMessage> groups) {
            this.groups = groups;
            return this;
        }

        @Override
        public TxCleanupMessageBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public TxCleanupMessageBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public List<EnlistedPartitionGroupMessage> groups() {
            return this.groups;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public TxCleanupMessage build() {
            return new TxCleanupMessageImpl(this.commit, this.commitTimestamp, this.groups, this.timestamp, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

