/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.tx.message.TxRecoveryMessage;
import org.apache.ignite.internal.tx.message.TxRecoveryMessageImpl;

class TxRecoveryMessageSerializer
implements MessageSerializer<TxRecoveryMessage> {
    public static final TxRecoveryMessageSerializer INSTANCE = new TxRecoveryMessageSerializer();

    private TxRecoveryMessageSerializer() {
    }

    public boolean writeMessage(TxRecoveryMessage msg, MessageWriter writer) throws MessageMappingException {
        TxRecoveryMessageImpl message = (TxRecoveryMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoxedLong("enlistmentConsistencyToken", message.enlistmentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("groupId", (NetworkMessage)message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

