/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.http.client.sse;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.sse.Event;
import io.micronaut.reactor.http.client.ReactorSseClient;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public class BridgedReactorSseClient
implements ReactorSseClient,
AutoCloseable {
    private final SseClient sseClient;

    public BridgedReactorSseClient(SseClient sseClient) {
        this.sseClient = sseClient;
    }

    @Override
    public <I> Flux<Event<ByteBuffer<?>>> eventStream(@NonNull HttpRequest<I> request) {
        return Flux.from((Publisher)this.sseClient.eventStream(request));
    }

    @Override
    public <I, B> Flux<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType) {
        return Flux.from((Publisher)this.sseClient.eventStream(request, eventType));
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType, @NonNull Argument<?> errorType) {
        return Flux.from((Publisher)this.sseClient.eventStream(request, eventType, errorType));
    }

    @Override
    public <I, B> Flux<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Class<B> eventType) {
        return Flux.from((Publisher)this.sseClient.eventStream(request, eventType));
    }

    @Override
    public <B> Flux<Event<B>> eventStream(@NonNull String uri, @NonNull Class<B> eventType) {
        return Flux.from((Publisher)this.sseClient.eventStream(uri, eventType));
    }

    @Override
    public <B> Flux<Event<B>> eventStream(@NonNull String uri, @NonNull Argument<B> eventType) {
        return Flux.from((Publisher)this.sseClient.eventStream(uri, eventType));
    }

    @Override
    public void close() throws Exception {
        if (this.sseClient instanceof AutoCloseable) {
            ((AutoCloseable)this.sseClient).close();
        }
    }
}

