/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.tablemanagement;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.migrationtools.tablemanagement.Namespace;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeDescriptor;
import org.apache.ignite.migrationtools.tablemanagement.TableTypeRegistry;
import org.apache.ignite3.catalog.ColumnType;
import org.apache.ignite3.catalog.definitions.ColumnDefinition;
import org.apache.ignite3.catalog.definitions.TableDefinition;
import org.apache.ignite3.client.IgniteClient;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.Table;
import org.jetbrains.annotations.Nullable;

public class PersistentTableTypeRegistryImpl
implements TableTypeRegistry {
    private static final String TABLE_NAME = Namespace.resolveTableName("TABLETYPEREGISTRY");
    private final IgniteClient client;
    private final CompletableFuture<KeyValueView<String, TableTypeRecord>> tableFuture;
    private final ObjectMapper jsonObjectMapper = new ObjectMapper();

    public PersistentTableTypeRegistryImpl(IgniteClient client) {
        this.client = client;
        this.tableFuture = this.initTable().thenApply(table -> table.keyValueView(String.class, TableTypeRecord.class));
    }

    private CompletableFuture<Table> initTable() {
        TableDefinition def = TableDefinition.builder((String)TABLE_NAME).ifNotExists().columns(new ColumnDefinition[]{ColumnDefinition.column((String)"TABLE_KEY", (ColumnType)ColumnType.VARCHAR), ColumnDefinition.column((String)"keyClass", (ColumnType)ColumnType.VARCHAR), ColumnDefinition.column((String)"valClass", (ColumnType)ColumnType.VARCHAR), ColumnDefinition.column((String)"keyColumnMappings", (ColumnType)ColumnType.VARCHAR.nullable(Boolean.valueOf(true))), ColumnDefinition.column((String)"valColumnMappings", (ColumnType)ColumnType.VARCHAR.nullable(Boolean.valueOf(true)))}).primaryKey(new String[]{"TABLE_KEY"}).build();
        return this.client.catalog().createTableAsync(def);
    }

    @Override
    @Nullable
    public TableTypeDescriptor typesForTable(String tableName) {
        KeyValueView<String, TableTypeRecord> table = this.tableFuture.join();
        @Nullable TableTypeRecord types = (TableTypeRecord)table.get(null, (Object)tableName);
        if (types == null) {
            return null;
        }
        try {
            Map keyColumnMappings = types.keyColumnMappings != null ? (Map)this.jsonObjectMapper.readValue(types.keyColumnMappings, Map.class) : null;
            Map valColumnMappings = types.valColumnMappings != null ? (Map)this.jsonObjectMapper.readValue(types.valColumnMappings, Map.class) : null;
            return new TableTypeDescriptor(types.keyClass, types.valClass, keyColumnMappings, valColumnMappings);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerTypesForTable(String tableName, TableTypeDescriptor tableDescriptor) {
        KeyValueView<String, TableTypeRecord> table = this.tableFuture.join();
        try {
            String keyColumnMappingsAsJson = tableDescriptor.keyFieldNameForColumn() != null ? this.jsonObjectMapper.writeValueAsString(tableDescriptor.keyFieldNameForColumn()) : null;
            String valColumnMappingsAsJson = tableDescriptor.valFieldNameForColumn() != null ? this.jsonObjectMapper.writeValueAsString(tableDescriptor.valFieldNameForColumn()) : null;
            TableTypeRecord record = new TableTypeRecord(tableDescriptor.keyClassName(), tableDescriptor.valClassName(), keyColumnMappingsAsJson, valColumnMappingsAsJson);
            table.put(null, (Object)tableName, (Object)record);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static class TableTypeRecord {
        private String keyClass;
        private String valClass;
        @Nullable
        private String keyColumnMappings;
        @Nullable
        private String valColumnMappings;

        public TableTypeRecord() {
        }

        public TableTypeRecord(String keyClass, String valClass, @Nullable String keyColumnMappings, @Nullable String valColumnMappings) {
            this.keyClass = keyClass;
            this.valClass = valClass;
            this.keyColumnMappings = keyColumnMappings;
            this.valColumnMappings = valColumnMappings;
        }
    }
}

