/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.configuration;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.configuration.NodeConfigUpdateCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite3.rest.client.api.NodeConfigurationApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class NodeConfigUpdateCall
implements Call<NodeConfigUpdateCallInput, String> {
    private final ApiClientFactory clientFactory;

    public NodeConfigUpdateCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(NodeConfigUpdateCallInput input) {
        NodeConfigurationApi client = this.createApiClient(input);
        try {
            return this.updateNodeConfig(client, input);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getNodeUrl()));
        }
    }

    private DefaultCallOutput<String> updateNodeConfig(NodeConfigurationApi api, NodeConfigUpdateCallInput input) throws ApiException {
        api.updateNodeConfiguration(input.getConfig());
        return DefaultCallOutput.success("Node configuration updated. " + AnsiStringSupport.ansi(AnsiStringSupport.fg(AnsiStringSupport.Color.YELLOW).mark("Restart the node to apply changes.")));
    }

    private NodeConfigurationApi createApiClient(NodeConfigUpdateCallInput input) {
        return new NodeConfigurationApi(this.clientFactory.getClient(input.getNodeUrl()));
    }
}

