/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.sql.planner;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.ignite3.internal.cli.call.sql.InvalidateCacheCallInput;
import org.apache.ignite3.internal.cli.call.sql.InvalidatePlannerCacheCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="invalidate-cache", description={"Invalidates SQL planner cache"})
public class InvalidateCacheReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private InvalidatePlannerCacheCall call;
    @CommandLine.Option(names={"--tables"}, description={"Tables filter"}, split=",")
    private List<String> tables;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(url -> InvalidateCacheCallInput.of(url, this.tables, List.of())).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Failed to invalidate SQL planner cache")).print());
    }
}

