/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.cli.commands.Options;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.CompleterFilter;

public class CompleterConf {
    private final List<String[]> commands;
    private final Set<String> enableOptions;
    private final Set<String> disableOptions;
    private final boolean exclusiveEnableOptions;
    private final boolean isSinglePositionalParameter;
    private final CompleterFilter filter;

    private CompleterConf(List<String[]> commands, Set<String> enableOptions, Set<String> disableOptions, boolean exclusiveEnableOptions, boolean isSinglePositionalParameter, CompleterFilter filter) {
        if (commands == null) {
            throw new IllegalArgumentException("commands must not be null");
        }
        this.commands = commands;
        this.enableOptions = enableOptions;
        this.disableOptions = disableOptions;
        this.exclusiveEnableOptions = exclusiveEnableOptions;
        this.isSinglePositionalParameter = isSinglePositionalParameter;
        this.filter = filter;
    }

    public static CompleterConf everytime() {
        return CompleterConf.builder().build();
    }

    public static CompleterConf forCommand(String ... words) {
        return CompleterConf.builder().command(words).build();
    }

    public static CompleterConfBuilder builder() {
        return new CompleterConfBuilder();
    }

    public List<String[]> commands() {
        return this.commands;
    }

    public Set<String> enableOptions() {
        return this.enableOptions;
    }

    public Set<String> disableOptions() {
        return this.disableOptions;
    }

    public boolean commandSpecific() {
        return !this.commands.isEmpty();
    }

    public boolean hasEnableOptions() {
        return this.enableOptions != null;
    }

    public boolean hasDisableOptions() {
        return this.disableOptions != null;
    }

    public boolean isExclusiveEnableOptions() {
        return this.exclusiveEnableOptions;
    }

    public boolean isSinglePositionalParameter() {
        return this.isSinglePositionalParameter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public CompleterFilter getFilter() {
        return this.filter;
    }

    public static class CompleterConfBuilder {
        private final List<String[]> command = new ArrayList<String[]>();
        private Set<String> enableOptions;
        private Set<String> disableOptions;
        private boolean exclusiveEnableOptions;
        private boolean isSinglePositionalParameter;
        private CompleterFilter filter;

        private CompleterConfBuilder() {
        }

        public CompleterConfBuilder command(String ... words) {
            this.command.add(Arrays.copyOf(words, words.length));
            return this;
        }

        public CompleterConfBuilder enableOptions(Options ... enableOptions) {
            this.enableOptions = Stream.of(enableOptions).flatMap(opt -> Stream.of(opt.fullName(), opt.shortName())).collect(Collectors.toSet());
            return this;
        }

        public CompleterConfBuilder enableOptions(String ... enableOptions) {
            this.enableOptions = Set.of(enableOptions);
            return this;
        }

        public CompleterConfBuilder disableOptions(String ... disableOptions) {
            this.disableOptions = Set.of(disableOptions);
            return this;
        }

        public CompleterConfBuilder singlePositionalParameter() {
            this.isSinglePositionalParameter = true;
            return this;
        }

        public CompleterConfBuilder filter(CompleterFilter filter) {
            this.filter = filter;
            return this;
        }

        public CompleterConfBuilder exclusiveEnableOptions() {
            this.exclusiveEnableOptions = true;
            return this;
        }

        public CompleterConf build() {
            return new CompleterConf(this.command, this.enableOptions, this.disableOptions, this.exclusiveEnableOptions, this.isSinglePositionalParameter, this.filter);
        }
    }
}

