/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.sql;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite3.internal.cli.sql.MetadataSupplier;
import org.apache.ignite3.internal.cli.sql.SchemaProvider;
import org.apache.ignite3.internal.cli.sql.SqlSchema;
import org.apache.ignite3.internal.cli.sql.SqlSchemaLoader;

public class SqlSchemaProvider
implements SchemaProvider {
    private static final int SCHEMA_UPDATE_TIMEOUT = 10;
    private final SqlSchemaLoader sqlSchemaLoader;
    private final int schemaUpdateTimeout;
    private final AtomicReference<SqlSchema> schema = new AtomicReference<Object>(null);
    private final AtomicReference<Instant> lastUpdate = new AtomicReference<Instant>(Instant.now());

    public SqlSchemaProvider(MetadataSupplier metadataSupplier) {
        this(metadataSupplier, 10);
    }

    SqlSchemaProvider(MetadataSupplier metadataSupplier, int schemaUpdateTimeout) {
        this.sqlSchemaLoader = new SqlSchemaLoader(metadataSupplier);
        this.schemaUpdateTimeout = schemaUpdateTimeout;
    }

    @Override
    public SqlSchema getSchema() {
        if (this.schema.compareAndSet(null, this.sqlSchemaLoader.loadSchema())) {
            this.lastUpdate.set(Instant.now());
            return this.schema.get();
        }
        if (Duration.between(this.lastUpdate.get(), Instant.now()).toSeconds() >= (long)this.schemaUpdateTimeout) {
            CompletableFuture.supplyAsync(() -> {
                this.schema.set(this.sqlSchemaLoader.loadSchema());
                this.lastUpdate.set(Instant.now());
                return this.schema.get();
            });
        }
        return this.schema.get();
    }

    public void initStateAsync() {
        CompletableFuture.supplyAsync(this::getSchema);
    }
}

