/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OrderedMap<V> {
    private final Map<String, V> map;
    private final List<String> orderedKeys;

    OrderedMap() {
        this.map = new HashMap<String, V>();
        this.orderedKeys = new ArrayList<String>();
    }

    OrderedMap(OrderedMap<V> other) {
        this.map = new HashMap<String, V>(other.map);
        this.orderedKeys = new ArrayList<String>(other.orderedKeys);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public V get(String key) {
        return this.map.get(key);
    }

    public V get(int index) {
        return this.map.get(this.orderedKeys.get(index));
    }

    public V remove(String key) {
        V res = this.map.remove(key);
        if (res != null) {
            this.orderedKeys.remove(key);
        }
        return res;
    }

    public void put(String key, V value) {
        assert (value != null);
        if (this.map.put(key, value) == null) {
            this.orderedKeys.add(key);
        }
    }

    public void putByIndex(int idx, String key, V value) {
        assert (!this.map.containsKey(key)) : key + " " + this.map;
        assert (value != null);
        if (idx >= this.orderedKeys.size()) {
            this.orderedKeys.add(key);
        } else {
            this.orderedKeys.add(idx, key);
        }
        this.map.put(key, value);
    }

    public void putAfter(String precedingKey, String key, V value) {
        assert (this.map.containsKey(precedingKey)) : precedingKey + " " + this.map;
        assert (!this.map.containsKey(key)) : key + " " + this.map;
        assert (value != null);
        int idx = this.orderedKeys.indexOf(precedingKey);
        this.putByIndex(idx + 1, key, value);
    }

    public void rename(String oldKey, String newKey) {
        if (!this.map.containsKey(oldKey)) {
            return;
        }
        if (this.map.containsKey(newKey)) {
            throw new IllegalArgumentException();
        }
        int idx = this.orderedKeys.indexOf(oldKey);
        this.orderedKeys.set(idx, newKey);
        V value = this.map.remove(oldKey);
        this.map.put(newKey, value);
    }

    public List<String> keys() {
        return new ArrayList<String>(this.orderedKeys);
    }

    public void reorderKeys(List<String> orderedKeys) {
        assert (this.map.keySet().equals(Set.copyOf(orderedKeys))) : this.map.keySet() + " : " + orderedKeys;
        this.orderedKeys.clear();
        this.orderedKeys.addAll(orderedKeys);
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
        this.orderedKeys.clear();
    }
}

