/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.ignite3.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite3.internal.deployunit.metastore.NodeEventCallback;
import org.apache.ignite3.internal.deployunit.metastore.status.NodeStatusKey;
import org.apache.ignite3.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metastorage.Entry;
import org.apache.ignite3.internal.metastorage.EntryEvent;
import org.apache.ignite3.internal.metastorage.WatchEvent;
import org.apache.ignite3.internal.metastorage.WatchListener;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.CompletableFutures;

public class NodeStatusWatchListener
implements WatchListener {
    private static final IgniteLogger LOG = Loggers.forClass(NodeStatusWatchListener.class);
    private final DeploymentUnitStore deploymentUnitStore;
    private final String nodeName;
    private final NodeEventCallback callback;
    private final ExecutorService executor;

    public NodeStatusWatchListener(DeploymentUnitStore deploymentUnitStore, String nodeName, NodeEventCallback callback) {
        this.deploymentUnitStore = deploymentUnitStore;
        this.nodeName = nodeName;
        this.callback = callback;
        this.executor = Executors.newFixedThreadPool(4, IgniteThreadFactory.create(nodeName, "NodeStatusWatchListener-pool", LOG, new ThreadOperation[0]));
    }

    @Override
    public CompletableFuture<Void> onUpdate(WatchEvent event) {
        for (EntryEvent e : event.entryEvents()) {
            Entry entry = e.newEntry();
            byte[] key = entry.key();
            byte[] value = entry.value();
            NodeStatusKey nodeStatusKey = NodeStatusKey.fromBytes(key);
            if (!Objects.equals(this.nodeName, nodeStatusKey.nodeId()) || value == null) continue;
            UnitNodeStatus nodeStatus = UnitNodeStatus.deserialize(value);
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> nodeStatus, this.executor).thenComposeAsync(status -> this.deploymentUnitStore.getAllNodeStatuses(status.id(), status.version()), (Executor)this.executor)).thenAccept(nodes -> this.callback.onUpdate(nodeStatus, (List<UnitNodeStatus>)nodes));
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public void stop() {
        this.executor.shutdown();
    }
}

