/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.server.persistence;

import java.util.concurrent.TimeUnit;

class CompactionStatisticsHolder {
    private final long revision;
    private final long startNanoTime;
    private long finishNanoTime;
    private boolean cancelled;
    private int totalKeysScanned;
    private int totalKeysRead;
    private int totalKeyRevisionsCompacted;
    private int totalKeysCompacted;
    private int totalTombstonesCompacted;
    private int batchesCommitted;
    private int batchesAborted;
    private int batchKeysRead;
    private int batchKeyRevisionsCompacted;
    private int batchKeysCompacted;
    private int batchTombstonesCompacted;
    private int auxiliaryMappingsCompacted;
    private long lastLockNanoTime;
    private long maxLockWaitNanos;
    private long maxLockHoldNanos;

    CompactionStatisticsHolder(long revision) {
        this.revision = revision;
        this.startNanoTime = System.nanoTime();
    }

    String info() {
        return "cancelled=" + this.cancelled + ", compactedRevision=" + this.revision + ", duration=" + TimeUnit.NANOSECONDS.toMillis(this.finishNanoTime - this.startNanoTime) + "ms, batchesCommitted=" + this.batchesCommitted + ", batchesAborted=" + this.batchesAborted + ", keysScanned=" + this.totalKeysScanned + ", keysRead=" + this.totalKeysRead + ", keyRevisionsCompacted=" + this.totalKeyRevisionsCompacted + ", keysCompacted=" + this.totalKeysCompacted + ", tombstonesCompacted=" + this.totalTombstonesCompacted + ", auxiliaryMappingsCompacted=" + this.auxiliaryMappingsCompacted + ", maxLockWait=" + TimeUnit.NANOSECONDS.toMicros(this.maxLockWaitNanos) + "us, maxLockHold=" + TimeUnit.NANOSECONDS.toMicros(this.maxLockHoldNanos) + "us";
    }

    void onCancelled() {
        this.cancelled = true;
    }

    void onFinished() {
        this.finishNanoTime = System.nanoTime();
    }

    void onBatchCommitted() {
        ++this.batchesCommitted;
        this.totalKeysRead += this.batchKeysRead;
        this.totalKeyRevisionsCompacted += this.batchKeyRevisionsCompacted;
        this.totalKeysCompacted += this.batchKeysCompacted;
        this.totalTombstonesCompacted += this.batchTombstonesCompacted;
        this.resetBatch();
    }

    void onBatchAborted() {
        ++this.batchesAborted;
        this.resetBatch();
    }

    void onKeyEncountered() {
        ++this.totalKeysScanned;
        ++this.batchKeysRead;
    }

    void onKeyRevisionCompacted() {
        ++this.batchKeyRevisionsCompacted;
    }

    void onTombstoneCompacted() {
        ++this.batchTombstonesCompacted;
    }

    void onKeyCompacted() {
        ++this.batchKeysCompacted;
    }

    void onAuxiliaryMappingCompacted() {
        ++this.auxiliaryMappingsCompacted;
    }

    void onBeforeWriteBatchLock() {
        this.lastLockNanoTime = System.nanoTime();
    }

    void onAfterWriteBatchLock() {
        this.maxLockWaitNanos = Math.max(this.maxLockWaitNanos, System.nanoTime() - this.lastLockNanoTime);
        this.lastLockNanoTime = System.nanoTime();
    }

    private void resetBatch() {
        this.batchKeysRead = 0;
        this.batchKeyRevisionsCompacted = 0;
        this.batchKeysCompacted = 0;
        this.batchTombstonesCompacted = 0;
        this.maxLockHoldNanos = Math.max(this.maxLockHoldNanos, System.nanoTime() - this.lastLockNanoTime);
    }
}

