/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.message;

import java.util.Objects;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessage;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessageBuilder;
import org.apache.ignite3.internal.network.message.FieldDescriptorMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class FieldDescriptorMessageImpl
implements FieldDescriptorMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 9;
    @IgniteToStringInclude
    private final String className;
    @IgniteToStringInclude
    private final byte flags;
    @IgniteToStringInclude
    private final String name;
    @IgniteToStringInclude
    private final int typeDescriptorId;

    private FieldDescriptorMessageImpl(String className, byte flags, String name, int typeDescriptorId) {
        this.className = className;
        this.flags = flags;
        this.name = name;
        this.typeDescriptorId = typeDescriptorId;
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public byte flags() {
        return this.flags;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int typeDescriptorId() {
        return this.typeDescriptorId;
    }

    public MessageSerializer serializer() {
        return FieldDescriptorMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(FieldDescriptorMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 9;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldDescriptorMessageImpl otherMessage = (FieldDescriptorMessageImpl)other;
        return Objects.equals(this.className, otherMessage.className) && Objects.equals(this.name, otherMessage.name) && this.flags == otherMessage.flags && this.typeDescriptorId == otherMessage.typeDescriptorId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.flags, this.typeDescriptorId, this.className, this.name);
        return result;
    }

    @Override
    public FieldDescriptorMessageImpl clone() {
        try {
            return (FieldDescriptorMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static FieldDescriptorMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements FieldDescriptorMessageBuilder {
        private String className;
        private byte flags;
        private String name;
        private int typeDescriptorId;

        private Builder() {
        }

        @Override
        public FieldDescriptorMessageBuilder className(String className) {
            Objects.requireNonNull(className, "className is not marked @Nullable");
            this.className = className;
            return this;
        }

        @Override
        public FieldDescriptorMessageBuilder flags(byte flags) {
            this.flags = flags;
            return this;
        }

        @Override
        public FieldDescriptorMessageBuilder name(String name) {
            Objects.requireNonNull(name, "name is not marked @Nullable");
            this.name = name;
            return this;
        }

        @Override
        public FieldDescriptorMessageBuilder typeDescriptorId(int typeDescriptorId) {
            this.typeDescriptorId = typeDescriptorId;
            return this;
        }

        @Override
        public String className() {
            return this.className;
        }

        @Override
        public byte flags() {
            return this.flags;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int typeDescriptorId() {
            return this.typeDescriptorId;
        }

        @Override
        public FieldDescriptorMessage build() {
            return new FieldDescriptorMessageImpl(Objects.requireNonNull(this.className, "className is not marked @Nullable"), this.flags, Objects.requireNonNull(this.name, "name is not marked @Nullable"), this.typeDescriptorId);
        }
    }
}

