/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.netty;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.network.netty.ChannelKey;
import org.apache.ignite3.internal.network.recovery.RecoveryDescriptor;
import org.apache.ignite3.internal.network.recovery.RecoveryDescriptorProvider;

public class DefaultRecoveryDescriptorProvider
implements RecoveryDescriptorProvider {
    private static final int DEFAULT_QUEUE_LIMIT = 10;
    private final Map<ChannelKey, RecoveryDescriptor> recoveryDescriptors = new ConcurrentHashMap<ChannelKey, RecoveryDescriptor>();

    @Override
    public RecoveryDescriptor getRecoveryDescriptor(String consistentId, UUID launchId, short connectionIndex) {
        ChannelKey key = new ChannelKey(consistentId, launchId, connectionIndex);
        return this.recoveryDescriptors.computeIfAbsent(key, channelKey -> new RecoveryDescriptor(10));
    }

    @Override
    public Collection<RecoveryDescriptor> getRecoveryDescriptorsByLaunchId(UUID launchId) {
        return this.recoveryDescriptors.entrySet().stream().filter(entry -> ((ChannelKey)entry.getKey()).launchId().equals(launchId)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Collection<RecoveryDescriptor> getAllRecoveryDescriptors() {
        return List.copyOf(this.recoveryDescriptors.values());
    }
}

