/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.netty;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite3.internal.thread.ThreadAttributes;
import org.apache.ignite3.internal.thread.ThreadOperation;

public class NamedNioEventLoopGroup
extends NioEventLoopGroup {
    private NamedNioEventLoopGroup(ThreadFactory threadFactory) {
        super(threadFactory);
    }

    public static NioEventLoopGroup create(final String namePrefix) {
        DefaultThreadFactory factory = new DefaultThreadFactory(namePrefix, 10){
            private final AtomicInteger nextId;
            {
                super(poolName, priority);
                this.nextId = new AtomicInteger();
            }

            protected Thread newThread(Runnable r, String unused) {
                return new NetworkThread(this.threadGroup, r, namePrefix + "-" + this.nextId.incrementAndGet());
            }
        };
        return new NamedNioEventLoopGroup((ThreadFactory)factory);
    }

    public static class NetworkThread
    extends FastThreadLocalThread
    implements ThreadAttributes {
        private static final Set<ThreadOperation> ALLOWED_OPERATIONS = Collections.emptySet();

        public NetworkThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }

        @Override
        public Set<ThreadOperation> allowedOperations() {
            return ALLOWED_OPERATIONS;
        }
    }
}

