/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.partition.replicator.network.command.WriteIntentSwitchCommand;
import org.apache.ignite3.internal.partition.replicator.network.command.WriteIntentSwitchCommandBuilder;
import org.apache.ignite3.internal.partition.replicator.network.command.WriteIntentSwitchCommandSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class WriteIntentSwitchCommandImpl
implements WriteIntentSwitchCommand,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 41;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final boolean full;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private int requiredCatalogVersion;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;
    @IgniteToStringInclude
    private final UUID txId;

    private WriteIntentSwitchCommandImpl(boolean commit, HybridTimestamp commitTimestamp, boolean full, HybridTimestamp initiatorTime, int requiredCatalogVersion, HybridTimestamp safeTime, UUID txId) {
        this.commit = commit;
        this.commitTimestamp = commitTimestamp;
        this.full = full;
        this.initiatorTime = initiatorTime;
        this.requiredCatalogVersion = requiredCatalogVersion;
        this.safeTime = safeTime;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public boolean full() {
        return this.full;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void requiredCatalogVersion(int requiredCatalogVersion) {
        this.requiredCatalogVersion = requiredCatalogVersion;
    }

    @Override
    public int requiredCatalogVersion() {
        return this.requiredCatalogVersion;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return WriteIntentSwitchCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(WriteIntentSwitchCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 41;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WriteIntentSwitchCommandImpl otherMessage = (WriteIntentSwitchCommandImpl)other;
        return Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit && this.full == otherMessage.full && this.requiredCatalogVersion == otherMessage.requiredCatalogVersion;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.full, this.requiredCatalogVersion, this.commitTimestamp, this.initiatorTime, this.safeTime, this.txId);
        return result;
    }

    @Override
    public WriteIntentSwitchCommandImpl clone() {
        try {
            return (WriteIntentSwitchCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static WriteIntentSwitchCommandBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements WriteIntentSwitchCommandBuilder {
        private boolean commit;
        private HybridTimestamp commitTimestamp;
        private boolean full;
        private HybridTimestamp initiatorTime;
        private int requiredCatalogVersion;
        private HybridTimestamp safeTime;
        private UUID txId;

        private Builder() {
        }

        @Override
        public WriteIntentSwitchCommandBuilder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandBuilder full(boolean full) {
            this.full = full;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandBuilder requiredCatalogVersion(int requiredCatalogVersion) {
            this.requiredCatalogVersion = requiredCatalogVersion;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public WriteIntentSwitchCommandBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public boolean full() {
            return this.full;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public int requiredCatalogVersion() {
            return this.requiredCatalogVersion;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public WriteIntentSwitchCommand build() {
            return new WriteIntentSwitchCommandImpl(this.commit, this.commitTimestamp, this.full, Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.requiredCatalogVersion, this.safeTime, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

