/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.placementdriver.message;

import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.placementdriver.message.LeaseGrantedMessageResponse;
import org.apache.ignite3.internal.placementdriver.message.LeaseGrantedMessageResponseBuilder;
import org.apache.ignite3.internal.placementdriver.message.PlacementDriverMessagesFactory;

class LeaseGrantedMessageResponseDeserializer
implements MessageDeserializer<LeaseGrantedMessageResponse> {
    private final LeaseGrantedMessageResponseBuilder msg;

    LeaseGrantedMessageResponseDeserializer(PlacementDriverMessagesFactory messageFactory) {
        this.msg = messageFactory.leaseGrantedMessageResponse();
    }

    @Override
    public Class<LeaseGrantedMessageResponse> klass() {
        return LeaseGrantedMessageResponse.class;
    }

    @Override
    public LeaseGrantedMessageResponse getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("accepted");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.accepted(tmp);
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readString("redirectProposal");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.redirectProposal(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(LeaseGrantedMessageResponse.class);
    }
}

