/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.logit;

import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.raft.storage.LogStorageFactory;
import org.apache.ignite3.internal.raft.storage.impl.LogStorageException;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.FeatureChecker;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.raft.jraft.option.RaftOptions;
import org.apache.ignite3.raft.jraft.storage.LogStorage;
import org.apache.ignite3.raft.jraft.storage.logit.option.StoreOptions;
import org.apache.ignite3.raft.jraft.storage.logit.storage.LogitLogStorage;
import org.apache.ignite3.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.StringUtils;
import sun.nio.ch.DirectBuffer;

public class LogitLogStorageFactory
implements LogStorageFactory {
    private static final IgniteLogger LOG = Loggers.forClass(LogitLogStorageFactory.class);
    private static final String LOG_DIR_PREFIX = "log-";
    private final ScheduledExecutorService checkpointExecutor;
    private final StoreOptions storeOptions;
    private final Path logPath;

    public LogitLogStorageFactory(String nodeName, StoreOptions storeOptions, Path logPath) {
        this.logPath = logPath;
        this.storeOptions = storeOptions;
        this.checkpointExecutor = Executors.newSingleThreadScheduledExecutor(IgniteThreadFactory.create(nodeName, "logit-checkpoint-executor", LOG, new ThreadOperation[0]));
        LogitLogStorageFactory.checkVmOptions();
    }

    private static void checkVmOptions() {
        try {
            Class.forName(DirectBuffer.class.getName());
        }
        catch (Throwable e) {
            throw new IgniteInternalException("sun.nio.ch.DirectBuffer is unavailable." + FeatureChecker.JAVA_STARTUP_PARAMS_WARN, e);
        }
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.checkpointExecutor);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public LogStorage createLogStorage(String groupId, RaftOptions raftOptions) {
        Requires.requireTrue(StringUtils.isNotBlank(groupId), "Blank log storage uri.");
        Path storagePath = this.resolveLogStoragePath(groupId);
        return new LogitLogStorage(storagePath, this.storeOptions, raftOptions, this.checkpointExecutor);
    }

    @Override
    public void destroyLogStorage(String uri) {
        Requires.requireTrue(StringUtils.isNotBlank(uri), "Blank log storage uri.");
        Path storagePath = this.resolveLogStoragePath(uri);
        if (!IgniteUtils.deleteIfExists(storagePath)) {
            throw new LogStorageException("Cannot delete directory " + storagePath);
        }
    }

    @Override
    public Set<String> raftNodeStorageIdsOnDisk() {
        return Set.of();
    }

    @Override
    public void sync() {
    }

    public Path resolveLogStoragePath(String groupId) {
        return this.logPath.resolve(LOG_DIR_PREFIX + groupId);
    }
}

