/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare.bounds;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.util.RexUtils;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class MultiBounds
extends SearchBounds {
    @IgniteToStringInclude
    private final List<SearchBounds> bounds;

    public MultiBounds(RexNode condition, List<SearchBounds> bounds) {
        super(condition);
        this.bounds = bounds;
    }

    public List<SearchBounds> bounds() {
        return this.bounds;
    }

    @Override
    public SearchBounds.Type type() {
        return SearchBounds.Type.MULTI;
    }

    @Override
    public SearchBounds accept(RexShuttle shuttle) {
        RexNode condition = this.condition();
        RexNode newCondition = shuttle.apply(condition);
        List<SearchBounds> newBounds = RexUtils.processSearchBounds(shuttle, this.bounds);
        if (newCondition == condition && newBounds == this.bounds) {
            return this;
        }
        return new MultiBounds(newCondition, newBounds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.bounds.equals(((MultiBounds)o).bounds);
    }

    public int hashCode() {
        return Objects.hash(this.bounds);
    }

    public String toString() {
        return S.toString(MultiBounds.class, this);
    }
}

