/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.UUID;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageIndexDescriptor;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.index.hash.HashIndexTree;
import org.apache.ignite3.internal.storage.pagememory.index.hash.PageMemoryHashIndexStorage;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.PageMemorySortedIndexStorage;
import org.apache.ignite3.internal.storage.pagememory.index.sorted.SortedIndexTree;
import org.apache.ignite3.internal.storage.util.StorageUtils;

class IndexStorageFactory {
    private final AbstractPageMemoryTableStorage tableStorage;
    private final int partitionId;
    private final IndexMetaTree indexMetaTree;
    private final FreeListImpl freeList;

    IndexStorageFactory(AbstractPageMemoryTableStorage tableStorage, int partitionId, IndexMetaTree indexMetaTree, FreeListImpl freeList) {
        this.tableStorage = tableStorage;
        this.partitionId = partitionId;
        this.indexMetaTree = indexMetaTree;
        this.freeList = freeList;
    }

    PageMemoryHashIndexStorage createHashIndexStorage(StorageHashIndexDescriptor indexDescriptor) {
        IndexTreeAndMeta<HashIndexTree> treeAndMeta = this.createHashIndexTreeAndMeta(indexDescriptor);
        return new PageMemoryHashIndexStorage(treeAndMeta.indexMeta, indexDescriptor, this.freeList, (HashIndexTree)treeAndMeta.indexTree, this.indexMetaTree, this.tableStorage.isVolatile());
    }

    PageMemoryHashIndexStorage restoreHashIndexStorage(StorageHashIndexDescriptor indexDescriptor, IndexMeta indexMeta) {
        return new PageMemoryHashIndexStorage(indexMeta, indexDescriptor, this.freeList, this.restoreHashIndexTree(indexMeta), this.indexMetaTree, this.tableStorage.isVolatile());
    }

    PageMemoryHashIndexStorage restoreHashIndexStorageForDestroy(IndexMeta indexMeta) {
        return new PageMemoryHashIndexStorage(indexMeta, null, this.freeList, this.restoreHashIndexTree(indexMeta), this.indexMetaTree, this.tableStorage.isVolatile());
    }

    private IndexTreeAndMeta<HashIndexTree> createHashIndexTreeAndMeta(StorageHashIndexDescriptor indexDescriptor) {
        return this.createIndexTree(indexDescriptor, metaPageId -> HashIndexTree.createNew(this.tableStorage.getTableId(), Integer.toString(this.tableStorage.getTableId()), this.partitionId, this.tableStorage.dataRegion().pageMemory(), this.tableStorage.engine().generateGlobalRemoveId(), metaPageId, this.freeList, indexDescriptor));
    }

    private HashIndexTree restoreHashIndexTree(IndexMeta indexMeta) {
        try {
            return HashIndexTree.restoreExisting(this.tableStorage.getTableId(), Integer.toString(this.tableStorage.getTableId()), this.partitionId, this.tableStorage.dataRegion().pageMemory(), this.tableStorage.engine().generateGlobalRemoveId(), indexMeta.metaPageId(), this.freeList);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(e);
        }
    }

    PageMemorySortedIndexStorage createSortedIndexStorage(StorageSortedIndexDescriptor indexDescriptor) {
        IndexTreeAndMeta<SortedIndexTree> treeAndMeta = this.createSortedIndexTreeAndMeta(indexDescriptor);
        return new PageMemorySortedIndexStorage(treeAndMeta.indexMeta, indexDescriptor, this.freeList, (SortedIndexTree)treeAndMeta.indexTree, this.indexMetaTree, this.tableStorage.isVolatile());
    }

    PageMemorySortedIndexStorage restoreSortedIndexStorage(StorageSortedIndexDescriptor indexDescriptor, IndexMeta indexMeta) {
        return new PageMemorySortedIndexStorage(indexMeta, indexDescriptor, this.freeList, this.restoreSortedIndexTree(indexDescriptor, indexMeta), this.indexMetaTree, this.tableStorage.isVolatile());
    }

    PageMemorySortedIndexStorage restoreSortedIndexStorageForDestroy(IndexMeta indexMeta) {
        return new PageMemorySortedIndexStorage(indexMeta, null, this.freeList, this.restoreSortedIndexTreeForDestroy(indexMeta), this.indexMetaTree, this.tableStorage.isVolatile());
    }

    private IndexTreeAndMeta<SortedIndexTree> createSortedIndexTreeAndMeta(StorageSortedIndexDescriptor indexDescriptor) {
        return this.createIndexTree(indexDescriptor, metaPageId -> SortedIndexTree.createNew(this.tableStorage.getTableId(), Integer.toString(this.tableStorage.getTableId()), this.partitionId, this.tableStorage.dataRegion().pageMemory(), this.tableStorage.engine().generateGlobalRemoveId(), metaPageId, this.freeList, indexDescriptor));
    }

    private SortedIndexTree restoreSortedIndexTree(StorageSortedIndexDescriptor indexDescriptor, IndexMeta indexMeta) {
        try {
            return SortedIndexTree.restoreExisting(this.tableStorage.getTableId(), Integer.toString(this.tableStorage.getTableId()), this.partitionId, this.tableStorage.dataRegion().pageMemory(), this.tableStorage.engine().generateGlobalRemoveId(), indexMeta.metaPageId(), this.freeList, indexDescriptor);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(e);
        }
    }

    private SortedIndexTree restoreSortedIndexTreeForDestroy(IndexMeta indexMeta) {
        try {
            return SortedIndexTree.restoreForDestroy(this.tableStorage.getTableId(), Integer.toString(this.tableStorage.getTableId()), this.partitionId, this.tableStorage.dataRegion().pageMemory(), this.tableStorage.engine().generateGlobalRemoveId(), indexMeta.metaPageId(), this.freeList);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(e);
        }
    }

    void updateDataStructuresIn(PageMemoryHashIndexStorage indexStorage) {
        HashIndexTree indexTree = (HashIndexTree)this.createHashIndexTreeAndMeta((StorageHashIndexDescriptor)indexStorage.indexDescriptor()).indexTree;
        indexStorage.updateDataStructures(this.indexMetaTree, this.freeList, indexTree);
    }

    void updateDataStructuresIn(PageMemorySortedIndexStorage indexStorage) {
        SortedIndexTree indexTree = (SortedIndexTree)this.createSortedIndexTreeAndMeta((StorageSortedIndexDescriptor)indexStorage.indexDescriptor()).indexTree;
        indexStorage.updateDataStructures(this.indexMetaTree, this.freeList, indexTree);
    }

    private <T> IndexTreeAndMeta<T> createIndexTree(StorageIndexDescriptor descriptor, IndexTreeConstructor<T> treeConstructor) {
        try {
            Object pageMemory = this.tableStorage.dataRegion().pageMemory();
            long metaPageId = pageMemory.allocatePage(this.freeList, this.tableStorage.getTableId(), this.partitionId, (byte)2);
            T tree = treeConstructor.createTree(metaPageId);
            IndexMeta.IndexType indexType = descriptor instanceof StorageHashIndexDescriptor ? IndexMeta.IndexType.HASH : IndexMeta.IndexType.SORTED;
            UUID nextRowIdUuidToBuild = descriptor.mustBeBuilt() ? StorageUtils.initialRowIdToBuild(this.partitionId).uuid() : null;
            IndexMeta indexMeta = new IndexMeta(descriptor.id(), indexType, metaPageId, nextRowIdUuidToBuild);
            boolean replaced = this.indexMetaTree.putx(indexMeta);
            assert (!replaced) : descriptor.id();
            return new IndexTreeAndMeta<T>(tree, indexMeta);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(e);
        }
    }

    private static class IndexTreeAndMeta<T> {
        final T indexTree;
        final IndexMeta indexMeta;

        IndexTreeAndMeta(T indexTree, IndexMeta indexMeta) {
            this.indexTree = indexTree;
            this.indexMeta = indexMeta;
        }
    }

    @FunctionalInterface
    private static interface IndexTreeConstructor<T> {
        public T createTree(long var1) throws IgniteInternalCheckedException;
    }
}

