/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessageImpl;

class EnlistedPartitionGroupMessageSerializer
implements MessageSerializer<EnlistedPartitionGroupMessage> {
    public static final EnlistedPartitionGroupMessageSerializer INSTANCE = new EnlistedPartitionGroupMessageSerializer();

    private EnlistedPartitionGroupMessageSerializer() {
    }

    @Override
    public boolean writeMessage(EnlistedPartitionGroupMessage msg, MessageWriter writer) throws MessageMappingException {
        EnlistedPartitionGroupMessageImpl message = (EnlistedPartitionGroupMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("tableIds", message.tableIds(), MessageCollectionItemType.INT);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

