/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.core;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite3.internal.raft.service.CommandClosure;
import org.apache.ignite3.internal.raft.service.RaftGroupListener;
import org.apache.ignite3.raft.jraft.Closure;
import org.apache.ignite3.raft.jraft.StateMachine;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.entity.EnumOutter;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.error.LogEntryCorruptedException;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.error.RaftException;
import org.apache.ignite3.raft.jraft.option.NodeOptions;
import org.apache.ignite3.raft.jraft.storage.LogManager;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.Utils;

public class IteratorImpl {
    private final StateMachine fsm;
    private final LogManager logManager;
    private final List<Closure> closures;
    private final long firstClosureIndex;
    private final NodeOptions options;
    private long currentIndex;
    private final long committedIndex;
    private LogEntry currEntry = new LogEntry();
    private final AtomicLong applyingIndex;
    private RaftException error;

    public IteratorImpl(StateMachine fsm, LogManager logManager, List<Closure> closures, long firstClosureIndex, long lastAppliedIndex, long committedIndex, AtomicLong applyingIndex, NodeOptions options) {
        this.fsm = fsm;
        this.logManager = logManager;
        this.closures = closures;
        this.firstClosureIndex = firstClosureIndex;
        this.currentIndex = lastAppliedIndex;
        this.committedIndex = committedIndex;
        this.applyingIndex = applyingIndex;
        this.options = options;
        this.next();
    }

    public String toString() {
        return "IteratorImpl [fsm=" + this.fsm + ", logManager=" + this.logManager + ", closures=" + this.closures + ", firstClosureIndex=" + this.firstClosureIndex + ", currentIndex=" + this.currentIndex + ", committedIndex=" + this.committedIndex + ", currEntry=" + this.currEntry + ", applyingIndex=" + this.applyingIndex + ", error=" + this.error + "]";
    }

    public LogEntry entry() {
        return this.currEntry;
    }

    public RaftException getError() {
        return this.error;
    }

    public boolean isGood() {
        return this.currentIndex <= this.committedIndex && !this.hasError();
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void next() {
        this.currEntry = null;
        if (this.currentIndex <= this.committedIndex) {
            ++this.currentIndex;
            if (this.currentIndex <= this.committedIndex) {
                try {
                    this.currEntry = this.logManager.getEntry(this.currentIndex);
                    if (this.currEntry == null) {
                        this.getOrCreateError().setType(EnumOutter.ErrorType.ERROR_TYPE_LOG);
                        this.getOrCreateError().getStatus().setError(-1, "Fail to get entry at index=%d while committed_index=%d", this.currentIndex, this.committedIndex);
                    }
                }
                catch (LogEntryCorruptedException e) {
                    this.getOrCreateError().setType(EnumOutter.ErrorType.ERROR_TYPE_LOG);
                    this.getOrCreateError().getStatus().setError(RaftError.EINVAL, e.getMessage(), new Object[0]);
                }
                this.applyingIndex.set(this.currentIndex);
            }
        }
    }

    public long getIndex() {
        return this.currentIndex;
    }

    public Closure done() {
        if (this.currentIndex < this.firstClosureIndex) {
            return null;
        }
        return this.closures.get((int)(this.currentIndex - this.firstClosureIndex));
    }

    protected void runTheRestClosureWithError() {
        for (long i = Math.max(this.currentIndex, this.firstClosureIndex); i <= this.committedIndex; ++i) {
            Closure done = this.closures.get((int)(i - this.firstClosureIndex));
            if (done == null) continue;
            Requires.requireNonNull(this.error, "error");
            Requires.requireNonNull(this.error.getStatus(), "error.status");
            Status status = this.error.getStatus();
            Utils.runClosureInThread(this.options.getCommonExecutor(), done, status);
        }
    }

    void runTheRestClosureWithShutdownException() {
        RaftGroupListener.ShutdownException shutdownException = new RaftGroupListener.ShutdownException();
        for (long i = Math.max(this.currentIndex, this.firstClosureIndex); i <= this.committedIndex; ++i) {
            Closure done = this.closures.get((int)(i - this.firstClosureIndex));
            if (!(done instanceof CommandClosure)) continue;
            CommandClosure commandClosure = (CommandClosure)((Object)done);
            commandClosure.result(shutdownException);
        }
    }

    public void setErrorAndRollback(long ntail, Status st) {
        Requires.requireTrue(ntail > 0L, "Invalid ntail=" + ntail);
        this.currentIndex = this.currEntry == null || this.currEntry.getType() != EnumOutter.EntryType.ENTRY_TYPE_DATA ? (this.currentIndex -= ntail) : (this.currentIndex -= ntail - 1L);
        this.currEntry = null;
        this.getOrCreateError().setType(EnumOutter.ErrorType.ERROR_TYPE_STATE_MACHINE);
        this.getOrCreateError().getStatus().setError(RaftError.ESTATEMACHINE, "StateMachine meet critical error when applying one or more tasks since index=%d, %s", this.currentIndex, st != null ? st.toString() : "none");
    }

    private RaftException getOrCreateError() {
        if (this.error == null) {
            this.error = new RaftException();
        }
        return this.error;
    }
}

