/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.Utils;
import org.apache.ignite3.raft.jraft.util.concurrent.DefaultFixedThreadsExecutorGroup;
import org.apache.ignite3.raft.jraft.util.concurrent.DefaultSingleThreadExecutor;
import org.apache.ignite3.raft.jraft.util.concurrent.ExecutorChooserFactory;
import org.apache.ignite3.raft.jraft.util.concurrent.FixedThreadsExecutorGroup;
import org.apache.ignite3.raft.jraft.util.concurrent.FixedThreadsExecutorGroupFactory;
import org.apache.ignite3.raft.jraft.util.concurrent.MpscSingleThreadExecutor;
import org.apache.ignite3.raft.jraft.util.concurrent.SingleThreadExecutor;

public class DefaultFixedThreadsExecutorGroupFactory
implements FixedThreadsExecutorGroupFactory {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultFixedThreadsExecutorGroupFactory.class);
    public static final DefaultFixedThreadsExecutorGroupFactory INSTANCE = new DefaultFixedThreadsExecutorGroupFactory();

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(int nThreads, String poolName, int maxPendingTasksPerThread) {
        return this.newExecutorGroup(nThreads, poolName, maxPendingTasksPerThread, false);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(int nThreads, String poolName, int maxPendingTasksPerThread, boolean useMpscQueue) {
        Requires.requireTrue(nThreads > 0, "nThreads must > 0");
        boolean mpsc = useMpscQueue && Utils.USE_MPSC_SINGLE_THREAD_EXECUTOR;
        SingleThreadExecutor[] children = new SingleThreadExecutor[nThreads];
        ThreadFactory threadFactory = mpsc ? this.newDaemonThreadFactory(poolName) : null;
        for (int i = 0; i < nThreads; ++i) {
            children[i] = mpsc ? new MpscSingleThreadExecutor(maxPendingTasksPerThread, threadFactory) : new DefaultSingleThreadExecutor(poolName, maxPendingTasksPerThread);
        }
        return new DefaultFixedThreadsExecutorGroup(children);
    }

    protected ThreadFactory newDaemonThreadFactory(String poolName) {
        return IgniteThreadFactory.createWithFixedPrefix(poolName, true, LOG, new ThreadOperation[0]);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(SingleThreadExecutor[] children) {
        return new DefaultFixedThreadsExecutorGroup(children);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(SingleThreadExecutor[] children, ExecutorChooserFactory.ExecutorChooser chooser) {
        return new DefaultFixedThreadsExecutorGroup(children, chooser);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(ExecutorService[] children) {
        return new DefaultFixedThreadsExecutorGroup(children);
    }

    @Override
    public FixedThreadsExecutorGroup newExecutorGroup(ExecutorService[] children, ExecutorChooserFactory.ExecutorChooser chooser) {
        return new DefaultFixedThreadsExecutorGroup(children, chooser);
    }
}

