/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.converters;

import java.util.concurrent.ExecutionException;
import javax.cache.configuration.Factory;
import javax.net.ssl.TrustManager;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.config.converters.ConfigurationConverter;
import org.apache.ignite.migrationtools.config.registry.ConfigurationRegistryInterface;
import org.apache.ignite.ssl.SslContextFactory;
import org.apache.ignite3.client.handler.configuration.ClientConnectorExtensionConfiguration;
import org.apache.ignite3.internal.network.configuration.NetworkExtensionConfiguration;
import org.apache.ignite3.internal.network.configuration.SslConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContextFactoryConverter
implements ConfigurationConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslContextFactoryConverter.class);

    private static void applySslConfigs(SslConfiguration target, SslContextFactory tcpCommSpi) throws InterruptedException, ExecutionException {
        TrustManager[] thrustManagers;
        target.keyStore().path().update((Object)tcpCommSpi.getKeyStoreFilePath()).get();
        target.keyStore().password().update((Object)new String(tcpCommSpi.getKeyStorePassword())).get();
        if (tcpCommSpi.getTrustStoreFilePath() != null) {
            target.trustStore().path().update((Object)tcpCommSpi.getTrustStoreFilePath()).get();
        }
        if (tcpCommSpi.getTrustStorePassword() != null) {
            target.trustStore().password().update((Object)new String(tcpCommSpi.getTrustStorePassword())).get();
        }
        if (tcpCommSpi.getKeyAlgorithm() != SslContextFactory.DFLT_KEY_ALGORITHM) {
            target.ciphers().update((Object)tcpCommSpi.getKeyAlgorithm());
        }
        if ((thrustManagers = tcpCommSpi.getTrustManagers()) != null && thrustManagers.length == 1 && thrustManagers[0].getClass().equals(SslContextFactory.getDisabledTrustManager().getClass())) {
            target.clientAuth().update((Object)"NONE").get();
        }
    }

    @Override
    public void convert(IgniteConfiguration src, ConfigurationRegistryInterface registry) throws ExecutionException, InterruptedException {
        Factory srcSslCf = src.getSslContextFactory();
        if (srcSslCf == null) {
            LOGGER.error("Could not find a CommunicationSpi in the source configuration.");
            return;
        }
        if (!(srcSslCf instanceof SslContextFactory)) {
            LOGGER.warn("SslContextFactory is not a SslContextFactory: {}", (Object)srcSslCf.getClass().getName());
            return;
        }
        SslContextFactory sslCtxFactory = (SslContextFactory)srcSslCf;
        SslConfiguration discoTarget = ((NetworkExtensionConfiguration)registry.getConfiguration(NetworkExtensionConfiguration.KEY)).network().ssl();
        SslContextFactoryConverter.applySslConfigs(discoTarget, sslCtxFactory);
        SslConfiguration jdbcTarget = ((ClientConnectorExtensionConfiguration)registry.getConfiguration(ClientConnectorExtensionConfiguration.KEY)).clientConnector().ssl();
        SslContextFactoryConverter.applySslConfigs(jdbcTarget, sslCtxFactory);
    }
}

