/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.persistence.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.cli.persistence.commands.ListCachesCmd;
import org.apache.ignite.migrationtools.cli.persistence.commands.MigrateCacheCmd;
import org.apache.ignite.migrationtools.cli.persistence.params.PersistenceParams;
import org.apache.ignite.migrationtools.config.Ignite2ConfigurationUtils;
import org.apache.ignite.migrationtools.persistence.Ignite2PersistenceTools;
import org.apache.ignite.migrationtools.persistence.MigrationKernalContext;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.logger.CliLoggers;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="persistent-data", description={"Commands to interact with an Ignite 2 node work directory"}, subcommands={ListCachesCmd.class, MigrateCacheCmd.class})
public class PersistenceBaseCmd
extends BaseCommand {
    private static final IgniteLogger LOGGER = CliLoggers.forClass(PersistenceBaseCmd.class);
    @CommandLine.Mixin
    private PersistenceParams params;

    @Nullable
    public static IgniteConfiguration createValidIgniteCfg(PersistenceParams params) {
        IgniteConfiguration cfg = Ignite2ConfigurationUtils.loadIgnite2Configuration((File)params.configFile().toFile(), (boolean)true);
        cfg.setWorkDirectory(params.workDir().toString());
        List errors = MigrationKernalContext.validateConfigurations((IgniteConfiguration)cfg);
        if (!errors.isEmpty()) {
            LOGGER.error("Could not load all the required configuration modules: %s", new Object[]{errors});
            return null;
        }
        return cfg;
    }

    public static List<MigrationKernalContext> createAndStartMigrationContext(PersistenceParams params, IgniteConfiguration cfg) throws IgniteCheckedException {
        List nodeFolders = Ignite2PersistenceTools.nodeFolderCandidates((IgniteConfiguration)cfg).stream().filter(c -> params.nodeConsistentId().equals(c.consistentId().toString())).collect(Collectors.toList());
        ArrayList<MigrationKernalContext> nodeContexts = new ArrayList<MigrationKernalContext>(nodeFolders.size());
        for (Ignite2PersistenceTools.NodeFolderDescriptor nodeFolder : nodeFolders) {
            MigrationKernalContext ctx = new MigrationKernalContext(cfg, nodeFolder.subFolderFile(), nodeFolder.consistentId());
            nodeContexts.add(ctx);
            ctx.start();
        }
        return nodeContexts;
    }

    public PersistenceParams params() {
        return this.params;
    }
}

