/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NullableInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.TimeIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class TimeInlineIndexKeyType
extends NullableInlineIndexKeyType<TimeIndexKey> {
    public TimeInlineIndexKeyType() {
        super(IndexKeyType.TIME, (short)8);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        long val1 = PageUtils.getLong(pageAddr, off + 1);
        long val2 = ((TimeIndexKey)key).nanos();
        return Integer.signum(Long.compare(val1, val2));
    }

    @Override
    protected int put0(long pageAddr, int off, TimeIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putLong(pageAddr, off + 1, key.nanos());
        return this.keySize + 1;
    }

    @Override
    protected TimeIndexKey get0(long pageAddr, int off) {
        long nanos = PageUtils.getLong(pageAddr, off + 1);
        return new TimeIndexKey(nanos);
    }

    @Override
    protected int inlineSize0(TimeIndexKey key) {
        return this.keySize + 1;
    }
}

