/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.maintenance;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cache.query.index.Index;
import org.apache.ignite.internal.cache.query.index.IndexProcessor;
import org.apache.ignite.internal.cache.query.index.sorted.SortedIndexDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexFactory;
import org.apache.ignite.internal.cache.query.index.sorted.inline.InlineIndexImpl;
import org.apache.ignite.internal.cache.query.index.sorted.maintenance.MaintenanceRebuildIndexTarget;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.processors.query.aware.IndexBuildStatusStorage;
import org.apache.ignite.internal.processors.query.schema.IndexRebuildCancelToken;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorClosure;
import org.apache.ignite.internal.processors.query.schema.SchemaIndexCacheVisitorImpl;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.SchemaManager;
import org.apache.ignite.internal.processors.query.schema.management.TableDescriptor;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.jetbrains.annotations.Nullable;

public class RebuildIndexAction
implements MaintenanceAction<Boolean> {
    private final List<MaintenanceRebuildIndexTarget> indexesToRebuild;
    private final GridKernalContext ctx;
    private final IgniteLogger log;

    public RebuildIndexAction(List<MaintenanceRebuildIndexTarget> indexesToRebuild, GridKernalContext ctx) {
        this.indexesToRebuild = indexesToRebuild;
        this.ctx = ctx;
        this.log = ctx.log(RebuildIndexAction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean execute() {
        GridCacheDatabaseSharedManager db = (GridCacheDatabaseSharedManager)this.ctx.cache().context().database();
        CheckpointManager cpMgr = db.getCheckpointManager();
        IndexBuildStatusStorage storage = this.ctx.query().getIdxBuildStatusStorage();
        try {
            this.prepareForRebuild(db, cpMgr, storage);
            for (MaintenanceRebuildIndexTarget params : this.indexesToRebuild) {
                int cacheId = params.cacheId();
                String idxName = params.idxName();
                try {
                    this.execute0(cacheId, idxName, storage, cpMgr);
                }
                catch (Exception e) {
                    this.log.error("Rebuilding index " + idxName + " for cache " + cacheId + " failed", e);
                    Boolean bl = false;
                    this.cleanUpAfterRebuild(cpMgr, storage);
                    return bl;
                }
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to prepare for the rebuild of indexes", e);
            Boolean bl = false;
            return bl;
        }
        finally {
            this.cleanUpAfterRebuild(cpMgr, storage);
        }
        this.unregisterMaintenanceTask();
        return true;
    }

    private void execute0(int cacheId, String idxName, IndexBuildStatusStorage storage, CheckpointManager cpMgr) throws Exception {
        GridCacheContext cctx = this.ctx.cache().context().cacheContext(cacheId);
        String cacheName = cctx.name();
        SchemaManager schemaMgr = this.ctx.query().schemaManager();
        String schemaName = schemaMgr.schemaName(cacheName);
        if (F.isEmpty(schemaName)) {
            return;
        }
        IndexDescriptor idxDesc = schemaMgr.index(schemaName, idxName);
        if (idxDesc == null) {
            return;
        }
        schemaMgr.dropIndex(schemaName, idxName, true);
        this.recreateIndex(idxDesc, cctx, cacheName, storage, schemaMgr);
        cpMgr.forceCheckpoint("afterIndexRebuild", null).futureFor(CheckpointState.FINISHED).get();
    }

    private void recreateIndex(IndexDescriptor oldIdxDesc, final GridCacheContext<?, ?> cctx, final String cacheName, final IndexBuildStatusStorage storage, SchemaManager schemaMgr) {
        GridFutureAdapter createIdxFut = new GridFutureAdapter();
        IndexRebuildCancelToken token = new IndexRebuildCancelToken();
        SchemaIndexCacheVisitorImpl visitor = new SchemaIndexCacheVisitorImpl(cctx, token, createIdxFut){

            @Override
            public void visit(SchemaIndexCacheVisitorClosure clo) {
                storage.onStartRebuildIndexes(cctx, false);
                try {
                    super.visit(clo);
                    this.buildIdxFut.get();
                }
                catch (Exception e) {
                    throw new IgniteException(e);
                }
                finally {
                    storage.onFinishRebuildIndexes(cacheName);
                }
            }
        };
        IndexProcessor idxProc = this.ctx.indexProcessor();
        assert (oldIdxDesc.type() == QueryIndexType.SORTED) : oldIdxDesc.type();
        TableDescriptor tblDesc = oldIdxDesc.table();
        SortedIndexDefinition definition = oldIdxDesc.index().unwrap(InlineIndexImpl.class).indexDefinition();
        Index newIdx = idxProc.createIndexDynamically(tblDesc.cacheInfo().cacheContext(), InlineIndexFactory.INSTANCE, definition, visitor);
        IndexDescriptor newIdxDesc = new IndexDescriptor(tblDesc, oldIdxDesc.name(), oldIdxDesc.type(), oldIdxDesc.keyDefinitions(), oldIdxDesc.isPk(), oldIdxDesc.isAffinity(), oldIdxDesc.inlineSize(), newIdx);
        try {
            schemaMgr.addIndex(tblDesc, newIdxDesc);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to register index in schema manager", e);
        }
        assert (createIdxFut.isDone());
    }

    private void prepareForRebuild(GridCacheDatabaseSharedManager db, CheckpointManager cpMgr, IndexBuildStatusStorage storage) throws IgniteCheckedException {
        db.resumeWalLogging();
        db.onStateRestored(null);
        cpMgr.addCheckpointListener(storage, null);
    }

    private void cleanUpAfterRebuild(CheckpointManager cpMgr, IndexBuildStatusStorage storage) {
        cpMgr.removeCheckpointListener(storage);
    }

    private void unregisterMaintenanceTask() {
        this.ctx.maintenanceRegistry().unregisterMaintenanceTask("indexRebuildMaintenanceTask");
    }

    @Override
    public String name() {
        return "rebuild";
    }

    @Override
    @Nullable
    public String description() {
        return "Rebuilding indexes";
    }
}

