/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.api;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.api.LocalCommand;
import org.apache.ignite.internal.management.api.PreparableCommand;
import org.jetbrains.annotations.Nullable;

public class CommandInvoker<A extends IgniteDataTransferObject> {
    @Nullable
    private final IgniteEx ignite;
    protected final Command<A, ?> cmd;
    protected final A arg;

    public CommandInvoker(Command<A, ?> cmd, A arg, @Nullable IgniteEx ignite) {
        this.cmd = cmd;
        this.arg = arg;
        this.ignite = ignite;
    }

    public boolean prepare(Consumer<String> printer) throws Exception {
        if (!(this.cmd instanceof PreparableCommand)) {
            return true;
        }
        return ((PreparableCommand)this.cmd).prepare(this.client(), this.igniteClient(), this.ignite, this.arg, printer);
    }

    public <R> R invoke(Consumer<String> printer, boolean verbose) throws Exception {
        Object res;
        if (this.cmd instanceof LocalCommand) {
            res = ((LocalCommand)this.cmd).execute(this.client(), this.igniteClient(), this.ignite, this.arg, printer);
        } else if (this.cmd instanceof ComputeCommand) {
            ComputeCommand cmd = (ComputeCommand)this.cmd;
            Collection<GridClientNode> cmdNodes = cmd.nodes(CommandUtils.nodes(this.client(), this.igniteClient(), this.ignite), this.arg);
            if (cmdNodes == null) {
                cmdNodes = Collections.singletonList(this.defaultNode());
            }
            try {
                res = CommandUtils.execute(this.client(), this.igniteClient(), this.ignite, cmd.taskClass(), this.arg, cmdNodes);
            }
            catch (Exception e) {
                res = cmd.handleException(e, printer);
            }
            cmd.printResult(this.arg, res, printer);
        } else {
            throw new IllegalArgumentException("Unknown command type: " + this.cmd);
        }
        return res;
    }

    protected GridClientNode defaultNode() throws GridClientException {
        return CommandUtils.clusterToClientNode(this.ignite.localNode());
    }

    @Nullable
    protected GridClient client() throws GridClientException {
        return null;
    }

    @Nullable
    protected IgniteClient igniteClient() {
        return null;
    }
}

