/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ignite.internal.management.cache.CacheConfiguration;
import org.apache.ignite.internal.management.cache.CacheConfigurationCollectorTaskArg;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.apache.ignite.lang.IgniteUuid;

public class CacheConfigurationCollectorJob
extends VisorJob<CacheConfigurationCollectorTaskArg, Map<String, CacheConfiguration>> {
    private static final long serialVersionUID = 0L;

    public CacheConfigurationCollectorJob(CacheConfigurationCollectorTaskArg arg, boolean debug) {
        super(arg, debug);
    }

    @Override
    protected Map<String, CacheConfiguration> run(CacheConfigurationCollectorTaskArg arg) {
        Collection<IgniteCacheProxy<?, ?>> caches = this.ignite.context().cache().jcaches();
        Pattern ptrn = arg.getRegex() != null ? Pattern.compile(arg.getRegex()) : null;
        boolean all = F.isEmpty(arg.getCacheNames());
        boolean hasPtrn = ptrn != null;
        HashMap<String, CacheConfiguration> res = U.newHashMap(caches.size());
        for (IgniteCacheProxy<?, ?> cache : caches) {
            boolean matched;
            if (!cache.context().userCache()) continue;
            String cacheName = cache.getName();
            boolean bl = hasPtrn ? ptrn.matcher(cacheName).find() : (matched = all || arg.getCacheNames().contains(cacheName));
            if (VisorTaskUtils.isRestartingCache(this.ignite, cacheName) || !matched) continue;
            CacheConfiguration cfg = this.config(cache.getConfiguration(org.apache.ignite.configuration.CacheConfiguration.class), cache.context().dynamicDeploymentId());
            res.put(cacheName, cfg);
        }
        return res;
    }

    protected CacheConfiguration config(org.apache.ignite.configuration.CacheConfiguration ccfg, IgniteUuid dynamicDeploymentId) {
        return new CacheConfiguration(this.ignite, ccfg, dynamicDeploymentId);
    }

    public String toString() {
        return S.toString(CacheConfigurationCollectorJob.class, this);
    }
}

