/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask;

import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class DurableBackgroundTaskResult<R> {
    private static final Object COMPLETED = new Object();
    private static final Object RESTART = new Object();
    private final Object state;
    @Nullable
    private final Throwable err;
    @GridToStringInclude
    @Nullable
    private final R res;

    private DurableBackgroundTaskResult(Object state, @Nullable Throwable err, @Nullable R res) {
        this.state = state;
        this.err = err;
        this.res = res;
    }

    public static <R> DurableBackgroundTaskResult<R> complete(@Nullable Throwable err) {
        return new DurableBackgroundTaskResult<Object>(COMPLETED, err, null);
    }

    public static <R> DurableBackgroundTaskResult<R> complete(@Nullable R res) {
        return new DurableBackgroundTaskResult<R>(COMPLETED, null, res);
    }

    public static <R> DurableBackgroundTaskResult<R> complete() {
        return new DurableBackgroundTaskResult<Object>(COMPLETED, null, null);
    }

    public static <R> DurableBackgroundTaskResult<R> restart(@Nullable Throwable err) {
        return new DurableBackgroundTaskResult<Object>(RESTART, err, null);
    }

    public boolean completed() {
        return this.state == COMPLETED;
    }

    public boolean restart() {
        return this.state == RESTART;
    }

    @Nullable
    public Throwable error() {
        return this.err;
    }

    @Nullable
    public R result() {
        return this.res;
    }

    public String toString() {
        return S.toString(DurableBackgroundTaskResult.class, this);
    }
}

