/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.util.Arrays;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageHistoryItem;

final class DistributedMetaStorageHistoryCache {
    private long startingVer;
    private DistributedMetaStorageHistoryItem[] items = new DistributedMetaStorageHistoryItem[16];
    private int from;
    private int to;
    private long sizeApproximation;

    public DistributedMetaStorageHistoryItem get(long ver) {
        int size = this.size();
        if (ver < this.startingVer || ver >= this.startingVer + (long)size) {
            return null;
        }
        return this.items[this.from + (int)(ver - this.startingVer) & this.items.length - 1];
    }

    public void put(long ver, DistributedMetaStorageHistoryItem item) {
        if (this.isEmpty()) {
            assert (this.from == 0);
            assert (this.to == 0);
            this.startingVer = ver;
        }
        if (ver == this.startingVer + (long)this.size()) {
            this.items[this.to] = item;
            this.sizeApproximation += item.estimateSize();
            this.to = this.next(this.to);
            if (this.from == this.to) {
                this.expandBuffer();
            }
        } else {
            assert (ver == this.startingVer + (long)this.size() - 1L) : this.startingVer + " " + this.from + " " + this.to + " " + ver;
            assert (this.items[this.to - 1 & this.items.length - 1].equals(item));
        }
    }

    public DistributedMetaStorageHistoryItem removeOldest() {
        DistributedMetaStorageHistoryItem oldItem = this.items[this.from];
        this.sizeApproximation -= oldItem.estimateSize();
        this.items[this.from] = null;
        this.from = this.next(this.from);
        ++this.startingVer;
        if (this.from == this.to) {
            this.to = 0;
            this.from = 0;
            this.startingVer = 0L;
            assert (this.sizeApproximation == 0L);
        }
        return oldItem;
    }

    public int size() {
        return this.to - this.from & this.items.length - 1;
    }

    public boolean isEmpty() {
        return this.sizeApproximation == 0L;
    }

    public void clear() {
        Arrays.fill(this.items, null);
        this.to = 0;
        this.from = 0;
        this.startingVer = 0L;
        this.sizeApproximation = 0L;
    }

    public long sizeInBytes() {
        return this.sizeApproximation;
    }

    public DistributedMetaStorageHistoryItem[] toArray() {
        int size = this.size();
        DistributedMetaStorageHistoryItem[] arr = new DistributedMetaStorageHistoryItem[size];
        if (this.from <= this.to) {
            System.arraycopy(this.items, this.from, arr, 0, size);
        } else {
            System.arraycopy(this.items, this.from, arr, 0, this.items.length - this.from);
            System.arraycopy(this.items, 0, arr, this.items.length - this.from, this.to);
        }
        return arr;
    }

    private int next(int i) {
        return i + 1 & this.items.length - 1;
    }

    private void expandBuffer() {
        DistributedMetaStorageHistoryItem[] items = this.items;
        DistributedMetaStorageHistoryItem[] newItems = new DistributedMetaStorageHistoryItem[items.length * 2];
        System.arraycopy(items, this.from, newItems, 0, items.length - this.from);
        System.arraycopy(items, 0, newItems, items.length - this.from, this.to);
        this.from = 0;
        this.to = items.length;
        this.items = newItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributedMetaStorageHistoryCache that = (DistributedMetaStorageHistoryCache)o;
        int size = this.size();
        if (size != that.size()) {
            return false;
        }
        if (this.startingVer != that.startingVer) {
            return false;
        }
        for (long ver = this.startingVer; ver < this.startingVer + (long)size; ++ver) {
            if (this.get(ver).equals(that.get(ver))) continue;
            return false;
        }
        assert (this.sizeInBytes() == that.sizeInBytes());
        return true;
    }
}

