/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemoryUtils;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.util.GridUnsafe;

public class PlatformOutputStreamImpl
implements PlatformOutputStream {
    protected final PlatformMemory mem;
    protected long data;
    protected int cap;
    protected int pos;

    public PlatformOutputStreamImpl(PlatformMemory mem) {
        this.mem = mem;
        this.data = mem.data();
        this.cap = mem.capacity();
    }

    @Override
    public void writeByte(byte val) {
        this.ensureCapacity(this.pos + 1);
        GridUnsafe.putByte(this.data + (long)this.pos++, val);
    }

    @Override
    public void writeByteArray(byte[] val) {
        this.copyAndShift(val, GridUnsafe.BYTE_ARR_OFF, val.length);
    }

    @Override
    public void writeByteArray(byte[] val, int off, int len) {
        this.copyAndShift(val, GridUnsafe.BYTE_ARR_OFF + (long)off, len);
    }

    @Override
    public void writeBoolean(boolean val) {
        this.writeByte(val ? (byte)1 : 0);
    }

    @Override
    public void writeBooleanArray(boolean[] val) {
        this.copyAndShift(val, GridUnsafe.BOOLEAN_ARR_OFF, val.length);
    }

    @Override
    public void writeShort(short val) {
        this.ensureCapacity(this.pos + 2);
        GridUnsafe.putShort(this.data + (long)this.pos, val);
        this.shift(2);
    }

    @Override
    public void writeShortArray(short[] val) {
        this.copyAndShift(val, GridUnsafe.SHORT_ARR_OFF, val.length << 1);
    }

    @Override
    public void writeChar(char val) {
        this.ensureCapacity(this.pos + 2);
        GridUnsafe.putChar(this.data + (long)this.pos, val);
        this.shift(2);
    }

    @Override
    public void writeCharArray(char[] val) {
        this.copyAndShift(val, GridUnsafe.CHAR_ARR_OFF, val.length << 1);
    }

    @Override
    public void writeInt(int val) {
        this.ensureCapacity(this.pos + 4);
        GridUnsafe.putInt(this.data + (long)this.pos, val);
        this.shift(4);
    }

    @Override
    public void writeIntArray(int[] val) {
        this.copyAndShift(val, GridUnsafe.INT_ARR_OFF, val.length << 2);
    }

    @Override
    public void writeShort(int pos, short val) {
        this.ensureCapacity(pos + 2);
        GridUnsafe.putShort(this.data + (long)pos, val);
    }

    @Override
    public void writeInt(int pos, int val) {
        this.ensureCapacity(pos + 4);
        GridUnsafe.putInt(this.data + (long)pos, val);
    }

    @Override
    public void writeFloat(float val) {
        this.writeInt(Float.floatToIntBits(val));
    }

    @Override
    public void writeFloatArray(float[] val) {
        this.copyAndShift(val, GridUnsafe.FLOAT_ARR_OFF, val.length << 2);
    }

    @Override
    public void writeLong(long val) {
        this.ensureCapacity(this.pos + 8);
        GridUnsafe.putLong(this.data + (long)this.pos, val);
        this.shift(8);
    }

    @Override
    public void writeLongArray(long[] val) {
        this.copyAndShift(val, GridUnsafe.LONG_ARR_OFF, val.length << 3);
    }

    @Override
    public void writeDouble(double val) {
        this.writeLong(Double.doubleToLongBits(val));
    }

    @Override
    public void writeDoubleArray(double[] val) {
        this.copyAndShift(val, GridUnsafe.DOUBLE_ARR_OFF, val.length << 3);
    }

    @Override
    public void write(byte[] arr, int off, int len) {
        this.copyAndShift(arr, GridUnsafe.BYTE_ARR_OFF + (long)off, len);
    }

    @Override
    public void write(long addr, int cnt) {
        this.copyAndShift(null, addr, cnt);
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public void position(int pos) {
        this.ensureCapacity(pos);
        this.unsafePosition(pos);
    }

    @Override
    public void close() {
    }

    @Override
    public byte[] array() {
        assert (false);
        throw new UnsupportedOperationException("Should not be called.");
    }

    @Override
    public byte[] arrayCopy() {
        assert (false);
        throw new UnsupportedOperationException("Should not be called.");
    }

    @Override
    public long offheapPointer() {
        assert (false);
        throw new UnsupportedOperationException("Should not be called.");
    }

    @Override
    public long rawOffheapPointer() {
        return this.data;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public void unsafeEnsure(int cap) {
        this.ensureCapacity(this.pos + cap);
    }

    @Override
    public void unsafePosition(int pos) {
        this.pos = pos;
    }

    @Override
    public void unsafeWriteByte(byte val) {
        GridUnsafe.putByte(this.data + (long)this.pos++, val);
    }

    @Override
    public void unsafeWriteBoolean(boolean val) {
        this.unsafeWriteByte(val ? (byte)1 : 0);
    }

    @Override
    public void unsafeWriteShort(short val) {
        GridUnsafe.putShort(this.data + (long)this.pos, val);
        this.shift(2);
    }

    @Override
    public void unsafeWriteShort(int pos, short val) {
        GridUnsafe.putShort(this.data + (long)pos, val);
    }

    @Override
    public void unsafeWriteChar(char val) {
        GridUnsafe.putChar(this.data + (long)this.pos, val);
        this.shift(2);
    }

    @Override
    public void unsafeWriteInt(int val) {
        GridUnsafe.putInt(this.data + (long)this.pos, val);
        this.shift(4);
    }

    @Override
    public void unsafeWriteInt(int pos, int val) {
        GridUnsafe.putInt(this.data + (long)pos, val);
    }

    @Override
    public void unsafeWriteLong(long val) {
        GridUnsafe.putLong(this.data + (long)this.pos, val);
        this.shift(8);
    }

    @Override
    public void unsafeWriteFloat(float val) {
        this.unsafeWriteInt(Float.floatToIntBits(val));
    }

    @Override
    public void unsafeWriteDouble(double val) {
        this.unsafeWriteLong(Double.doubleToLongBits(val));
    }

    @Override
    public void synchronize() {
        PlatformMemoryUtils.length(this.mem.pointer(), this.pos);
    }

    protected void ensureCapacity(int reqCap) {
        if (reqCap > this.cap) {
            int newCap = this.cap << 1;
            if (newCap < reqCap) {
                newCap = reqCap;
            }
            this.mem.reallocate(newCap);
            assert (this.mem.capacity() >= newCap);
            this.data = this.mem.data();
            this.cap = newCap;
        }
    }

    protected void shift(int cnt) {
        this.pos += cnt;
    }

    private void copyAndShift(Object src, long off, int len) {
        this.ensureCapacity(this.pos + len);
        GridUnsafe.copyHeapOffheap(src, off, this.data + (long)this.pos, len);
        this.shift(len);
    }

    @Override
    public int capacity() {
        return this.cap;
    }
}

