/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnConfiguration;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsColumnOverrides;
import org.apache.ignite.internal.processors.query.stat.config.StatisticsObjectConfiguration;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;
import org.apache.ignite.internal.sql.command.SqlStatisticsCommands;
import org.apache.ignite.internal.util.typedef.F;

public class SqlAnalyzeCommand
extends SqlStatisticsCommands {
    public static final String MAX_CHANGED_PARTITION_ROWS_PERCENT = "MAX_CHANGED_PARTITION_ROWS_PERCENT";
    public static final String DISTINCT = "DISTINCT";
    public static final String TOTAL = "TOTAL";
    public static final String SIZE = "SIZE";
    public static final String NULLS = "NULLS";
    protected List<StatisticsObjectConfiguration> configs = new ArrayList<StatisticsObjectConfiguration>();

    @Override
    public SqlCommand parse(SqlLexer lex) {
        do {
            SqlQualifiedName tblQName = SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]);
            String[] cols = this.parseColumnList(lex, true);
            Map<String, String> params = this.parseParams(lex);
            StatisticsTarget target = new StatisticsTarget(tblQName.schemaName(), tblQName.name(), cols);
            this.configs.add(this.buildConfig(target, params));
        } while (!this.tryEnd(lex));
        return this;
    }

    public SqlAnalyzeCommand() {
    }

    public SqlAnalyzeCommand(Collection<StatisticsTarget> targets) {
        this(targets, null);
    }

    public SqlAnalyzeCommand(Collection<StatisticsTarget> targets, Map<String, String> params) {
        this.targets = new ArrayList<StatisticsTarget>(targets);
        for (StatisticsTarget tgt : targets) {
            this.configs.add(this.buildConfig(tgt, params));
        }
    }

    public StatisticsObjectConfiguration buildConfig(StatisticsTarget target, Map<String, String> params) throws IgniteSQLException {
        byte maxChangedRows = SqlAnalyzeCommand.getByteOrDefault(params, MAX_CHANGED_PARTITION_ROWS_PERCENT, (byte)15);
        StatisticsColumnOverrides overrides = SqlAnalyzeCommand.overrides(params);
        if (!F.isEmpty(params)) {
            throw new IgniteSQLException("");
        }
        List<StatisticsColumnConfiguration> colCfgs = target.columns() == null ? Collections.emptyList() : Arrays.stream(target.columns()).map(col -> new StatisticsColumnConfiguration((String)col, overrides)).collect(Collectors.toList());
        return new StatisticsObjectConfiguration(target.key(), colCfgs, maxChangedRows);
    }

    private static StatisticsColumnOverrides overrides(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        Long total = null;
        Long nulls = null;
        Long distinct = null;
        Integer size = null;
        String val = params.remove(TOTAL);
        if (val != null) {
            total = Long.parseLong(val);
        }
        if ((val = params.remove(DISTINCT)) != null) {
            distinct = Long.parseLong(val);
        }
        if ((val = params.remove(NULLS)) != null) {
            nulls = Long.parseLong(val);
        }
        if ((val = params.remove(SIZE)) != null) {
            size = Integer.parseInt(val);
        }
        if (size == null && nulls == null && total == null && distinct == null) {
            return null;
        }
        return new StatisticsColumnOverrides(nulls, distinct, total, size);
    }

    private static byte getByteOrDefault(Map<String, String> map, String key, byte dfltVal) {
        if (map == null) {
            return dfltVal;
        }
        String val = map.remove(key);
        return val == null ? dfltVal : Byte.valueOf(val);
    }

    public Collection<StatisticsObjectConfiguration> configurations() {
        return this.configs;
    }

    private Map<String, String> parseParams(SqlLexer lex) {
        SqlLexerToken nextTok = lex.lookAhead();
        if (nextTok.token() == null || nextTok.tokenType() == SqlLexerTokenType.SEMICOLON || nextTok.tokenType() == SqlLexerTokenType.COMMA) {
            return null;
        }
        SqlParserUtils.skipIfMatchesKeyword(lex, "WITH");
        lex.shift();
        String paramsStr = lex.token();
        String[] params = paramsStr.split(",");
        HashMap<String, String> res = new HashMap<String, String>(params.length);
        for (String param : params) {
            int p = param.indexOf("=");
            res.put(param.substring(0, p), param.substring(p + 1));
        }
        return res;
    }
}

