/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class PartitionTable {
    private final String alias;
    private final String cacheName;
    private final String affColName;
    private final String secondAffColName;
    private int joinGrp;

    public PartitionTable(String alias, String cacheName, @Nullable String affColName, @Nullable String secondAffColName) {
        this.alias = alias;
        this.cacheName = cacheName;
        if (affColName == null && secondAffColName != null) {
            this.affColName = secondAffColName;
            this.secondAffColName = null;
        } else {
            this.affColName = affColName;
            this.secondAffColName = secondAffColName;
        }
    }

    public String alias() {
        return this.alias;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public boolean isAffinityColumn(String colName) {
        return F.eq(colName, this.affColName) || F.eq(colName, this.secondAffColName);
    }

    public int joinGroup() {
        return this.joinGrp;
    }

    public void joinGroup(int joinGrp) {
        this.joinGrp = joinGrp;
    }

    public String toString() {
        return S.toString(PartitionTable.class, this);
    }
}

