/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.AfterRetryPolicyProvider;
import com.azure.core.http.policy.BeforeRetryPolicyProvider;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class HttpPolicyProviders {
    private static final String INVALID_POLICY = "HttpPipelinePolicy created with %s resulted in a null policy.";
    private static final List<BeforeRetryPolicyProvider> BEFORE_PROVIDER = new ArrayList<BeforeRetryPolicyProvider>();
    private static final List<AfterRetryPolicyProvider> AFTER_PROVIDER = new ArrayList<AfterRetryPolicyProvider>();

    private HttpPolicyProviders() {
    }

    public static void addBeforeRetryPolicies(List<HttpPipelinePolicy> policies) {
        HttpPolicyProviders.addPolices(policies, BEFORE_PROVIDER);
    }

    public static void addAfterRetryPolicies(List<HttpPipelinePolicy> policies) {
        HttpPolicyProviders.addPolices(policies, AFTER_PROVIDER);
    }

    private static void addPolices(List<HttpPipelinePolicy> policies, List<? extends HttpPolicyProvider> providers) {
        for (HttpPolicyProvider httpPolicyProvider : providers) {
            HttpPipelinePolicy policy = httpPolicyProvider.create();
            if (policy == null) {
                throw new NullPointerException(String.format(INVALID_POLICY, httpPolicyProvider.getClass()));
            }
            policies.add(policy);
        }
    }

    static {
        ServiceLoader.load(BeforeRetryPolicyProvider.class, HttpPolicyProviders.class.getClassLoader()).forEach(BEFORE_PROVIDER::add);
        ServiceLoader.load(AfterRetryPolicyProvider.class, HttpPolicyProviders.class.getClassLoader()).forEach(AFTER_PROVIDER::add);
    }
}

