/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary.builder;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.binary.builder.BinaryBuilderReader;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializationAware;
import org.apache.ignite.internal.binary.builder.BinaryBuilderSerializer;

class BinaryLazyArrayList
extends AbstractList<Object>
implements BinaryBuilderSerializationAware {
    private final BinaryBuilderReader reader;
    private final int off;
    private List<Object> delegate;

    BinaryLazyArrayList(BinaryBuilderReader reader, int size) {
        this.reader = reader;
        this.off = reader.position() - 1 - 4 - 1;
        assert (size >= 0);
        for (int i = 0; i < size; ++i) {
            reader.skipValue();
        }
    }

    private void ensureDelegateInit() {
        if (this.delegate == null) {
            int size = this.reader.readIntPositioned(this.off + 1);
            this.reader.position(this.off + 1 + 4 + 1);
            this.delegate = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                this.delegate.add(this.reader.parseValue());
            }
        }
    }

    @Override
    public Object get(int idx) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.get(idx));
    }

    @Override
    public boolean add(Object o) {
        this.ensureDelegateInit();
        return this.delegate.add(o);
    }

    @Override
    public void add(int idx, Object element) {
        this.ensureDelegateInit();
        this.delegate.add(idx, element);
    }

    @Override
    public Object set(int idx, Object element) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.set(idx, element));
    }

    @Override
    public Object remove(int idx) {
        this.ensureDelegateInit();
        return BinaryUtils.unwrapLazy(this.delegate.remove(idx));
    }

    @Override
    public void clear() {
        if (this.delegate == null) {
            this.delegate = new ArrayList<Object>();
        } else {
            this.delegate.clear();
        }
    }

    @Override
    public boolean addAll(int idx, Collection<?> c) {
        return this.delegate.addAll(idx, c);
    }

    @Override
    protected void removeRange(int fromIdx, int toIdx) {
        this.ensureDelegateInit();
        this.delegate.subList(fromIdx, toIdx).clear();
    }

    @Override
    public int size() {
        if (this.delegate == null) {
            return this.reader.readIntPositioned(this.off + 1);
        }
        return this.delegate.size();
    }

    @Override
    public void writeTo(BinaryWriterExImpl writer, BinaryBuilderSerializer ctx) {
        if (this.delegate == null) {
            int size = this.reader.readIntPositioned(this.off + 1);
            int hdrSize = 6;
            writer.write(this.reader.array(), this.off, hdrSize);
            this.reader.position(this.off + hdrSize);
            for (int i = 0; i < size; ++i) {
                Object o = this.reader.parseValue();
                ctx.writeValue(writer, o);
            }
        } else {
            writer.writeByte((byte)24);
            writer.writeInt(this.delegate.size());
            byte colType = this.reader.array()[this.off + 1 + 4];
            writer.writeByte(colType);
            int oldPos = this.reader.position();
            for (Object o : this.delegate) {
                ctx.writeValue(writer, o);
            }
            this.reader.position(oldPos);
        }
    }
}

