/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.commandline.meta.tasks;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataListResult;
import org.apache.ignite.internal.commandline.meta.tasks.MetadataTypeArgs;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class MetadataInfoTask
extends VisorMultiNodeTask<MetadataTypeArgs, MetadataListResult, MetadataListResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<MetadataTypeArgs, MetadataListResult> job(MetadataTypeArgs arg) {
        return new MetadataListJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected MetadataListResult reduce0(List<ComputeJobResult> results) {
        if (results.isEmpty()) {
            throw new IgniteException("Empty job results");
        }
        if (results.size() > 1) {
            throw new IgniteException("Invalid job results: " + results);
        }
        if (results.get(0).getException() != null) {
            throw results.get(0).getException();
        }
        return (MetadataListResult)results.get(0).getData();
    }

    private static class MetadataListJob
    extends VisorJob<MetadataTypeArgs, MetadataListResult> {
        private static final long serialVersionUID = 0L;

        protected MetadataListJob(@Nullable MetadataTypeArgs arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected MetadataListResult run(@Nullable MetadataTypeArgs arg) throws IgniteException {
            if (arg == null) {
                return new MetadataListResult(((CacheObjectBinaryProcessorImpl)this.ignite.context().cacheObjects()).binaryMetadata());
            }
            int typeId = arg.typeId(this.ignite.context());
            return new MetadataListResult(Collections.singleton(((CacheObjectBinaryProcessorImpl)this.ignite.context().cacheObjects()).binaryMetadata(typeId)));
        }
    }
}

