/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.io.Closeable;
import java.util.function.BooleanSupplier;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

abstract class AbstractTransmission
implements Closeable {
    private final BooleanSupplier stopChecker;
    protected final int chunkSize;
    protected final IgniteLogger log;
    protected TransmissionMeta meta;
    protected long transferred;

    protected AbstractTransmission(TransmissionMeta meta, BooleanSupplier stopChecker, IgniteLogger log, int chunkSize) {
        A.notNull(meta, "Initial file meta cannot be null");
        A.notNullOrEmpty(meta.name(), "Trasmisson name cannot be empty or null");
        A.ensure(meta.offset() >= 0L, "File start position cannot be negative");
        A.ensure(meta.count() > 0L, "Total number of bytes to transfer must be greater than zero");
        A.notNull(stopChecker, "Process stop checker cannot be null");
        A.ensure(chunkSize > 0, "Size of chunks to transfer data must be positive");
        this.stopChecker = stopChecker;
        this.log = log.getLogger(AbstractTransmission.class);
        this.chunkSize = chunkSize;
        this.meta = meta;
    }

    public TransmissionMeta state() {
        assert (this.meta != null);
        return new TransmissionMeta(this.meta.name(), this.meta.offset() + this.transferred, this.meta.count() - this.transferred, this.meta.params(), this.meta.policy(), null);
    }

    public long transferred() {
        return this.transferred;
    }

    protected boolean stopped() {
        return this.stopChecker.getAsBoolean();
    }

    protected boolean hasNextChunk() {
        return this.transferred < this.meta.count();
    }

    public String toString() {
        return S.toString(AbstractTransmission.class, this);
    }
}

