/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessControlException;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.GridInternalWrapper;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;

public abstract class AbstractSecurityAwareExternalizable<T>
implements Externalizable,
GridInternalWrapper<T> {
    protected UUID subjectId;
    protected T original;
    @IgniteInstanceResource
    protected transient IgniteEx ignite;

    protected AbstractSecurityAwareExternalizable() {
    }

    protected AbstractSecurityAwareExternalizable(UUID subjectId, T original) {
        this.subjectId = Objects.requireNonNull(subjectId, "Parameter 'subjectId' cannot be null.");
        this.original = Objects.requireNonNull(original, "Parameter 'original' cannot be null.");
    }

    protected void logAccessDeniedMessage(AccessControlException e) {
        this.ignite.context().log(this.getClass()).error("The operation can't be executed because the current subject doesn't have appropriate permission [subjectId=" + this.subjectId + "].", e);
    }

    @Override
    public T userObject() {
        return this.original;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.subjectId);
        out.writeObject(this.original);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.subjectId = U.readUuid(in);
        this.original = in.readObject();
    }
}

