/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.performancestatistics.handlers.IgnitePerformanceStatisticsHandler;
import org.apache.ignite.internal.performancestatistics.util.OrderedFixedSizeStructure;
import org.apache.ignite.internal.performancestatistics.util.Utils;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.util.typedef.F;

public class QueryHandler
implements IgnitePerformanceStatisticsHandler {
    private final Map<GridCacheQueryType, Map<String, AggregatedQueryInfo>> aggrQuery = new EnumMap<GridCacheQueryType, Map<String, AggregatedQueryInfo>>(GridCacheQueryType.class);
    private final Map<GridCacheQueryType, Map<UUID, Map<Long, long[]>>> readsById = new EnumMap<GridCacheQueryType, Map<UUID, Map<Long, long[]>>>(GridCacheQueryType.class);
    private final Map<GridCacheQueryType, OrderedFixedSizeStructure<Long, Query>> topSlow = new EnumMap<GridCacheQueryType, OrderedFixedSizeStructure<Long, Query>>(GridCacheQueryType.class);

    @Override
    public void query(UUID nodeId, GridCacheQueryType type, String text, long id, long startTime, long duration, boolean success) {
        Query query = new Query(type, text, nodeId, id, startTime, duration, success);
        OrderedFixedSizeStructure tree = this.topSlow.computeIfAbsent(type, queryType -> new OrderedFixedSizeStructure());
        tree.put(duration, query);
        AggregatedQueryInfo info = this.aggrQuery.computeIfAbsent(type, queryType -> new HashMap()).computeIfAbsent(text, queryText -> new AggregatedQueryInfo());
        info.merge(nodeId, id, duration, success);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void queryReads(UUID nodeId, GridCacheQueryType type, UUID queryNodeId, long id, long logicalReads, long physicalReads) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, JsonNode> results() {
        ObjectNode sqlRes = Utils.MAPPER.createObjectNode();
        ObjectNode scanRes = Utils.MAPPER.createObjectNode();
        this.buildResult(GridCacheQueryType.SQL_FIELDS, sqlRes);
        this.buildResult(GridCacheQueryType.SCAN, scanRes);
        ArrayNode topSlowSql = Utils.MAPPER.createArrayNode();
        ArrayNode topSlowScan = Utils.MAPPER.createArrayNode();
        this.buildTopSlowResult(GridCacheQueryType.SQL_FIELDS, topSlowSql);
        this.buildTopSlowResult(GridCacheQueryType.SCAN, topSlowScan);
        return F.asMap((Object)"sql", (Object)sqlRes, (Object)"scan", (Object)scanRes, (Object)"topSlowSql", (Object)topSlowSql, (Object)"topSlowScan", (Object)topSlowScan);
    }

    private void buildResult(GridCacheQueryType type, ObjectNode jsonRes) {
        if (!this.aggrQuery.containsKey(type)) {
            return;
        }
        Map<String, AggregatedQueryInfo> res = this.aggrQuery.get(type);
        res.forEach((text, info) -> {
            info.ids.forEach((uuid, ids) -> {
                if (!this.readsById.containsKey(type) || !this.readsById.get(type).containsKey(uuid)) {
                    return;
                }
                Map<Long, long[]> reads = this.readsById.get(type).get(uuid);
                ids.forEach(id -> {
                    long[] readsArr = (long[])reads.get(id);
                    if (readsArr == null) {
                        return;
                    }
                    info.logicalReads += readsArr[0];
                    info.physicalReads += readsArr[1];
                });
            });
            ObjectNode sql = (ObjectNode)jsonRes.get(text);
            if (sql == null) {
                sql = Utils.MAPPER.createObjectNode();
                sql.put("count", info.count);
                sql.put("duration", TimeUnit.NANOSECONDS.toMillis(info.totalDuration));
                sql.put("logicalReads", info.logicalReads);
                sql.put("physicalReads", info.physicalReads);
                sql.put("failures", info.failures);
                jsonRes.set(text, (JsonNode)sql);
            }
        });
    }

    private void buildTopSlowResult(GridCacheQueryType type, ArrayNode jsonRes) {
        if (!this.topSlow.containsKey(type)) {
            return;
        }
        OrderedFixedSizeStructure<Long, Query> tree = this.topSlow.get(type);
        tree.values().forEach(query -> {
            ObjectNode json = Utils.MAPPER.createObjectNode();
            json.put("text", query.text);
            json.put("startTime", query.startTime);
            json.put("duration", TimeUnit.NANOSECONDS.toMillis(query.duration));
            json.put("nodeId", String.valueOf(query.queryNodeId));
            json.put("success", query.success);
            json.put("logicalReads", 0);
            json.put("physicalReads", 0);
            jsonRes.add((JsonNode)json);
            if (!this.readsById.containsKey(type) || !this.readsById.get(type).containsKey(query.queryNodeId)) {
                return;
            }
            long[] readsArr = this.readsById.get(type).get(query.queryNodeId).get(query.id);
            if (readsArr == null) {
                return;
            }
            json.put("logicalReads", readsArr[0]);
            json.put("physicalReads", readsArr[1]);
        });
    }

    private static class Query {
        final GridCacheQueryType type;
        final String text;
        final UUID queryNodeId;
        final long id;
        final long startTime;
        final long duration;
        final boolean success;

        public Query(GridCacheQueryType type, String text, UUID queryNodeId, long id, long startTime, long duration, boolean success) {
            this.type = type;
            this.text = text;
            this.queryNodeId = queryNodeId;
            this.id = id;
            this.startTime = startTime;
            this.duration = duration;
            this.success = success;
        }
    }

    private static class AggregatedQueryInfo {
        int count;
        long totalDuration;
        long logicalReads;
        long physicalReads;
        int failures;
        final Map<UUID, Set<Long>> ids = new HashMap<UUID, Set<Long>>();

        private AggregatedQueryInfo() {
        }

        public void merge(UUID queryNodeId, long id, long duration, boolean success) {
            ++this.count;
            this.totalDuration += duration;
            if (!success) {
                ++this.failures;
            }
            this.ids.computeIfAbsent(queryNodeId, k -> new HashSet()).add(id);
        }
    }
}

