/*
 * Decompiled with CFR 0.152.
 */
package com.papertrail.profiler.jaxrs;

import com.papertrail.profiler.CpuProfile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.joda.time.Duration;

@Path(value="/pprof")
public class CpuProfileResource {
    final Lock lock = new ReentrantLock();

    @Produces(value={"pprof/raw"})
    @GET
    @Path(value="profile")
    public byte[] profile(@QueryParam(value="duration") @DefaultValue(value="10") Integer duration, @QueryParam(value="frequency") @DefaultValue(value="100") Integer frequency) throws IOException {
        return this.doProfile(duration, frequency, Thread.State.RUNNABLE);
    }

    @Produces(value={"pprof/raw"})
    @GET
    @Path(value="contention")
    public byte[] contention(@QueryParam(value="duration") @DefaultValue(value="10") Integer duration, @QueryParam(value="frequency") @DefaultValue(value="100") Integer frequency) throws IOException {
        return this.doProfile(duration, frequency, Thread.State.BLOCKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doProfile(int duration, int frequency, Thread.State state) throws IOException {
        if (this.lock.tryLock()) {
            try {
                CpuProfile profile = CpuProfile.record(Duration.standardSeconds((long)duration), frequency, state);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                if (profile == null) {
                    throw new RuntimeException("could not create CpuProfile");
                }
                profile.writeGoogleProfile(stream);
                byte[] byArray = stream.toByteArray();
                return byArray;
            }
            finally {
                this.lock.unlock();
            }
        }
        throw new RuntimeException("Only one profile request may be active at a time");
    }
}

