/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#pragma once

#include <s2/third_party/absl/base/port.h>
#include <string>
#include <vector>

#include "available_detector.h"
#include "info_collector.h"
#include "runtime/service_app.h"
#include "utils/error_code.h"

namespace pegasus {
namespace server {

class info_collector_app : public ::dsn::service_app
{
public:
    info_collector_app(const dsn::service_app_info *info);
    virtual ~info_collector_app(void);

    virtual ::dsn::error_code start(const std::vector<std::string> &args) override;
    virtual ::dsn::error_code stop(bool cleanup = false) override;

private:
    info_collector _collector;
    available_detector _detector;
    bool _updater_started;
};
}
} // namespace
