/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.partition;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;

public class PartitionGroup
extends ArrayList<Node> {
    private int raftId;

    public PartitionGroup() {
    }

    public PartitionGroup(Collection<Node> nodes) {
        this.addAll(nodes);
    }

    public PartitionGroup(int raftId, Node ... nodes) {
        this.addAll(Arrays.asList(nodes));
        this.raftId = raftId;
    }

    public PartitionGroup(PartitionGroup other) {
        super(other);
        this.raftId = other.getRaftId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionGroup group = (PartitionGroup)o;
        return Objects.equals(this.raftId, group.getRaftId()) && super.equals(group);
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getRaftId());
        dataOutputStream.writeInt(this.size());
        for (Node node : this) {
            NodeSerializeUtils.serialize(node, dataOutputStream);
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this.raftId = buffer.getInt();
        int nodeNum = buffer.getInt();
        for (int i2 = 0; i2 < nodeNum; ++i2) {
            Node node = new Node();
            NodeSerializeUtils.deserialize(node, buffer);
            this.add(node);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.raftId, super.hashCode());
    }

    public RaftNode getHeader() {
        return new RaftNode((Node)this.get(0), this.getRaftId());
    }

    public int getRaftId() {
        return this.raftId;
    }

    public void setRaftId(int raftId) {
        this.raftId = raftId;
    }

    @Override
    public String toString() {
        return super.toString() + ", id = " + this.raftId;
    }
}

